/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.freemarker;

import java.io.IOException;
import java.io.Serializable;

import org.kuali.rice.krad.uif.component.Component;
import org.springframework.util.StringUtils;

import freemarker.core.Environment;
import freemarker.core.InlineTemplateAdaptor;
import freemarker.template.TemplateException;

/**
 * Inline FreeMarker template adaptor for supporting script.ftl 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FreeMarkerScriptAdaptor implements InlineTemplateAdaptor, Serializable {

    private static final long serialVersionUID = 1675270336764602352L;

    /**
     * Render a script template inline.
     * 
     * {@inheritDoc}
     */
    @Override
    public void accept(Environment env) throws TemplateException, IOException {
        String script = FreeMarkerInlineRenderUtils.resolve(env, "value", String.class);

        if (!StringUtils.hasText(script)) {
            return;
        }

        Component component = FreeMarkerInlineRenderUtils.resolve(env, "component", Component.class);
        String role = FreeMarkerInlineRenderUtils.resolve(env, "role", String.class);
        FreeMarkerInlineRenderUtils.renderScript(script, component, role, env.getOut());
    }

}
