/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.ModuleService;
import org.kuali.rice.krad.uif.field.AttributeQueryResult;
import org.kuali.rice.krad.uif.service.AttributeQueryService;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.QueryControllerService;
import org.springframework.web.servlet.ModelAndView;

public class QueryControllerServiceImpl
implements QueryControllerService {
    private static final Logger LOG = LogManager.getLogger(QueryControllerServiceImpl.class);
    private ModelAndViewService modelAndViewService;
    private AttributeQueryService attributeQueryService;

    @Override
    public ModelAndView performLookup(UifFormBase form) {
        Properties urlParameters = form.getActionParametersAsProperties();
        Class<?> lookupDataObjectClass = this.getLookupDataObjectClass(urlParameters);
        if (lookupDataObjectClass == null) {
            throw new RuntimeException("Lookup data object class not found for lookup call");
        }
        urlParameters.put("performDirtyCheck", "false");
        String baseLookupUrl = this.getLookupUrlFromModuleService(lookupDataObjectClass, urlParameters);
        if (StringUtils.isNotBlank((String)baseLookupUrl)) {
            urlParameters = new Properties();
        } else {
            baseLookupUrl = urlParameters.getProperty("baseLookupUrl");
            urlParameters.remove("baseLookupUrl");
            this.buildLookupUrlParameters(form, form.getRequest(), lookupDataObjectClass, urlParameters);
        }
        return this.getModelAndViewService().performRedirect(form, baseLookupUrl, urlParameters);
    }

    protected Class<?> getLookupDataObjectClass(Properties urlParameters) {
        Class<?> lookupDataObjectClass;
        String lookupObjectClassName = urlParameters.getProperty("dataObjectClassName");
        try {
            lookupDataObjectClass = Class.forName(lookupObjectClassName);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to get class for name: " + lookupObjectClassName);
            throw new RuntimeException("Unable to get class for name: " + lookupObjectClassName, e);
        }
        return lookupDataObjectClass;
    }

    protected String getLookupUrlFromModuleService(Class<?> lookupDataObjectClass, Properties urlParameters) {
        String lookupUrl = null;
        ModuleService responsibleModuleService = KRADServiceLocatorWeb.getKualiModuleService().getResponsibleModuleService(lookupDataObjectClass);
        if (responsibleModuleService != null && responsibleModuleService.isExternalizable(lookupDataObjectClass)) {
            lookupUrl = responsibleModuleService.getExternalizableDataObjectLookupUrl(lookupDataObjectClass, urlParameters);
        }
        return lookupUrl;
    }

    protected void buildLookupUrlParameters(UifFormBase form, HttpServletRequest request, Class<?> lookupDataObjectClass, Properties urlParameters) {
        urlParameters.setProperty("methodToCall", "start");
        String autoSearchString = urlParameters.getProperty("autoSearch");
        if (Boolean.parseBoolean(autoSearchString)) {
            urlParameters.setProperty("methodToCall", "search");
        }
        this.buildLookupCriteriaParameters(form, request, lookupDataObjectClass, urlParameters);
        urlParameters.setProperty("returnLocation", form.getFormPostUrl());
        urlParameters.setProperty("returnFormKey", form.getFormKey());
    }

    protected void buildLookupCriteriaParameters(UifFormBase form, HttpServletRequest request, Class<?> lookupDataObjectClass, Properties urlParameters) {
        String lookupParameterString = urlParameters.getProperty("lookupParameters");
        if (StringUtils.isBlank((String)lookupParameterString)) {
            return;
        }
        Map<String, String> lookupParameterFields = KRADUtils.getMapFromParameterString(lookupParameterString);
        for (Map.Entry<String, String> lookupParameter : lookupParameterFields.entrySet()) {
            String lookupParameterValue = LookupUtils.retrieveLookupParameterValue(form, request, lookupDataObjectClass, lookupParameter.getValue(), lookupParameter.getKey());
            if (!StringUtils.isNotBlank((String)lookupParameterValue)) continue;
            urlParameters.setProperty("lookupCriteria['" + lookupParameter.getValue() + "']", lookupParameterValue);
        }
        urlParameters.remove("lookupParameters");
    }

    @Override
    public AttributeQueryResult performFieldSuggest(UifFormBase form) {
        HttpServletRequest request = form.getRequest();
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (Object parameterName : request.getParameterMap().keySet()) {
            if (!parameterName.toString().startsWith("queryParameters")) continue;
            String fieldName = StringUtils.substringBetween((String)parameterName.toString(), (String)"queryParameters[\"", (String)"\"]");
            String fieldValue = request.getParameter(parameterName.toString());
            queryParameters.put(fieldName, fieldValue);
        }
        String queryFieldId = request.getParameter("queryFieldId");
        if (StringUtils.isBlank((String)queryFieldId)) {
            throw new RuntimeException("Unable to find id for field to perform query on under request parameter name: queryFieldId");
        }
        String queryTerm = request.getParameter("queryTerm");
        if (StringUtils.isBlank((String)queryTerm)) {
            throw new RuntimeException("Unable to find id for query term value for attribute query on under request parameter name: queryTerm");
        }
        return this.getAttributeQueryService().performFieldSuggestQuery(form.getViewPostMetadata(), queryFieldId, queryTerm, queryParameters);
    }

    @Override
    public AttributeQueryResult performFieldQuery(UifFormBase form) {
        HttpServletRequest request = form.getRequest();
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        for (Object parameterName : request.getParameterMap().keySet()) {
            if (!parameterName.toString().startsWith("queryParameters")) continue;
            String fieldName = StringUtils.substringBetween((String)parameterName.toString(), (String)"queryParameters[\"", (String)"\"]");
            String fieldValue = request.getParameter(parameterName.toString());
            queryParameters.put(fieldName, fieldValue);
        }
        String queryFieldId = request.getParameter("queryFieldId");
        if (StringUtils.isBlank((String)queryFieldId)) {
            throw new RuntimeException("Unable to find id for field to perform query on under request parameter name: queryFieldId");
        }
        return this.getAttributeQueryService().performFieldQuery(form.getViewPostMetadata(), queryFieldId, queryParameters);
    }

    protected ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }

    public AttributeQueryService getAttributeQueryService() {
        return this.attributeQueryService;
    }

    public void setAttributeQueryService(AttributeQueryService attributeQueryService) {
        this.attributeQueryService = attributeQueryService;
    }
}

