/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.exception;

/**
 * Use this when the data dictionary cannot find a matching business object's attribute entry for a populated business
 * object that
 * runs through the data dictionary validation service and its methods.
 */
public class UnknownBusinessClassAttributeException extends RuntimeException {
    private static final long serialVersionUID = -2021739544938001742L;

    /**
     * Create an UnknownBusinessClassAttributeException with the given message
     *
     * @param message
     */
    public UnknownBusinessClassAttributeException(String message) {
        super(message);
    }

    /**
     * Create an UnknownBusinessClassAttributeException with the given message and cause
     *
     * @param message
     * @param cause
     */
    public UnknownBusinessClassAttributeException(String message, Throwable cause) {
        super(message, cause);
    }
}
