/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

/**
 * An object that represents a simple suggestion with a label and a value.  For use when returning a suggestion without
 * specifying valuePropertyName or labelPropertyName on the Suggest widget.  This class is also available for
 * extension purposes.
 */
public class SimpleSuggestObject {
    private String label;
    private String value;

    /**
     * Create a SimpleSuggestObject
     *
     * @param label the label to show for the suggestion
     * @param value the value to insert when the label is selected
     */
    public SimpleSuggestObject(String label, String value){
        this.label = label;
        this.value = value;
    }

    /**
     * The label of the suggestion
     *
     * @return the label
     */
    public String getLabel() {
        return label;
    }

    /**
     * Set the label
     *
     * @param label
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * The value of the suggestion (inserted when the suggestion is picked)
     *
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * Set the value
     *
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }
}
