/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.layout;

import java.util.ArrayList;
import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.layout.CssGridLayoutManagerBase;
import org.kuali.rice.krad.uif.layout.CssGridSizes;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="cssGridLayout", parent="Uif-CssGridLayout")
public class CssGridLayoutManager
extends CssGridLayoutManagerBase {
    private static final long serialVersionUID = 1830635073147703757L;
    private int defaultItemSize;
    private CssGridSizes defaultItemSizes = new CssGridSizes();

    @Override
    public void performFinalize(Object model, LifecycleElement component) {
        super.performFinalize(model, component);
        Container container = (Container)component;
        this.cellItems = new ArrayList();
        this.processNormalLayout(container);
    }

    private void processNormalLayout(Container container) {
        for (Component component : container.getItems()) {
            List<String> cellCssClasses;
            if (component == null) continue;
            int colSpan = this.defaultItemSize;
            if (component.getColSpan() > 1 && component.getColSpan() <= 12) {
                colSpan = component.getColSpan();
            }
            if ((cellCssClasses = component.getWrapperCssClasses()) == null) {
                component.setWrapperCssClasses(new ArrayList<String>());
                cellCssClasses = component.getWrapperCssClasses();
            }
            this.calculateCssClassAndSize(component, cellCssClasses, this.defaultItemSizes, colSpan);
            this.addLeftClearCssClass(cellCssClasses);
            this.cellCssClassAttributes.add(this.getCellStyleClassesAsString(cellCssClasses));
            this.cellItems.add(component);
        }
    }

    @BeanTagAttribute
    public int getDefaultItemSize() {
        return this.defaultItemSize;
    }

    public void setDefaultItemSize(int defaultItemSize) {
        this.defaultItemSize = defaultItemSize;
    }

    public CssGridSizes getDefaultItemSizes() {
        return this.defaultItemSizes;
    }

    public void setDefaultItemSizes(CssGridSizes defaultItemSizes) {
        this.defaultItemSizes = defaultItemSizes;
    }
}

