/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.service;

import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

/**
 * Controller service that provides the basic entry and exit methods.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface ControllerService {

    /**
     * Initial method called when requesting a new view instance.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView start(UifFormBase form);

    /**
     * Invokes the configured {@link org.kuali.rice.krad.uif.view.ViewAuthorizer} to verify the user has access to
     * open the view.
     *
     * @throws org.kuali.rice.krad.exception.AuthorizationException thrown if user does not have access to the view
     */
    void checkViewAuthorization(UifFormBase form) throws AuthorizationException;

    /**
     * Invoked when a session timeout occurs.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView sessionTimeout(UifFormBase form);

    /**
     * Invoked when the cancel action is invoked on a view.
     *
     * @param form form instance containing the model data
     * @return ModelAndView instance for rendering the view
     */
    ModelAndView cancel(UifFormBase form);
}
