/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;

public final class JAXBAssert {
    private JAXBAssert() {
    }

    public static void assertEqualXmlMarshalUnmarshal(Object objectToMarshal, String expectedXml, Class<?> ... classesToBeBound) {
        String marshaledXml = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound);
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(objectToMarshal, (Writer)stringWriter);
            marshaledXml = stringWriter.toString();
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object actual = unmarshaller.unmarshal((Reader)new StringReader(stringWriter.toString()));
            Assert.assertEquals((String)"Unmarshalled object should be equal to original objectToMarshall.", (Object)objectToMarshal, (Object)actual);
            Object expected = unmarshaller.unmarshal((Reader)new StringReader(expectedXml.trim()));
            Assert.assertEquals((String)"Unmarshalled objects should be equal.", (Object)expected, (Object)actual);
        }
        catch (Throwable e) {
            System.err.println("Outputting marshaled XML from failed assertion:\n" + marshaledXml);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException("Failed to marshall/unmarshall with JAXB.  See the nested exception for details.", e);
        }
    }

    public static void assertEqualXmlMarshalUnmarshalWithResource(Object objectToMarshal, InputStream expectedXml, Class<?> ... classesToBeBound) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(expectedXml));
        StringWriter writer = new StringWriter();
        int data = -1;
        while ((data = reader.read()) != -1) {
            writer.write(data);
        }
        JAXBAssert.assertEqualXmlMarshalUnmarshal(objectToMarshal, writer.toString(), classesToBeBound);
    }
}

