/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.type;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="KRMSTypeService", targetNamespace="http://rice.kuali.org/krms/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface KrmsTypeRepositoryService {
    @WebMethod(operationName="createKrmsType")
    @WebResult(name="krmsType")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, allEntries=true)
    public KrmsTypeDefinition createKrmsType(@WebParam(name="krmsType") KrmsTypeDefinition var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updateKrmsType")
    @WebResult(name="krmsType")
    @CacheEvict(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, allEntries=true)
    public KrmsTypeDefinition updateKrmsType(@WebParam(name="krmsType") KrmsTypeDefinition var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="getTypeById")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'id=' + #p0")
    public KrmsTypeDefinition getTypeById(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getTypeByName")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'namespaceCode=' + #p0 + '|' + 'name=' + #p1")
    public KrmsTypeDefinition getTypeByName(@WebParam(name="namespaceCode") String var1, @WebParam(name="name") String var2) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="findAllTypesByNamespace")
    @XmlElementWrapper(name="namespaceTypes", required=true)
    @XmlElement(name="namespaceType", required=false)
    @WebResult(name="namespaceTypes")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'allByNamespaceCode=' + #p0")
    public List<KrmsTypeDefinition> findAllTypesByNamespace(@WebParam(name="namespaceCode") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllTypes")
    @XmlElementWrapper(name="types", required=true)
    @XmlElement(name="type", required=false)
    @WebResult(name="types")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'all'")
    public List<KrmsTypeDefinition> findAllTypes();

    @WebMethod(operationName="findAllAgendaTypesByContextId")
    @XmlElementWrapper(name="agendaTypes", required=true)
    @XmlElement(name="agendaType", required=false)
    @WebResult(name="agendaTypes")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'{AgendaType}contextId=' + #p0")
    public List<KrmsTypeDefinition> findAllAgendaTypesByContextId(@WebParam(name="contextId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAgendaTypeByAgendaTypeIdAndContextId")
    @WebResult(name="type")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'agendaTypeId=' + #p0 + '|' + 'contextId=' + #p1")
    public KrmsTypeDefinition getAgendaTypeByAgendaTypeIdAndContextId(@WebParam(name="agendaTypeId") String var1, @WebParam(name="contextId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllRuleTypesByContextId")
    @XmlElementWrapper(name="ruleTypes", required=true)
    @XmlElement(name="ruleType", required=false)
    @WebResult(name="ruleTypes")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'{RuleType}contextId=' + #p0")
    public List<KrmsTypeDefinition> findAllRuleTypesByContextId(@WebParam(name="contextId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getRuleTypeByRuleTypeIdAndContextId")
    @WebResult(name="ruleType")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'ruleTypeId=' + #p0 + '|' + 'contextId=' + #p1")
    public KrmsTypeDefinition getRuleTypeByRuleTypeIdAndContextId(@WebParam(name="ruleTypeId") String var1, @WebParam(name="contextId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findAllActionTypesByContextId")
    @XmlElementWrapper(name="actionTypes", required=true)
    @XmlElement(name="actionType", required=false)
    @WebResult(name="actionTypes")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'{ActionType}contextId=' + #p0")
    public List<KrmsTypeDefinition> findAllActionTypesByContextId(@WebParam(name="contextId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getActionTypeByActionTypeIdAndContextId")
    @WebResult(name="actionType")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KRMSTypeType"}, key="'actionTypeId=' + #p0 + '|' + 'contextId=' + #p1")
    public KrmsTypeDefinition getActionTypeByActionTypeIdAndContextId(@WebParam(name="actionTypeId") String var1, @WebParam(name="contextId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAttributeDefinitionById")
    @WebResult(name="attribute")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KrmsAttributionDefinitionType"}, key="'attributeDefinitionId=' + #p0")
    public KrmsAttributeDefinition getAttributeDefinitionById(@WebParam(name="attributeDefinitionId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAttributeDefinitionByName")
    @WebResult(name="attribute")
    @Cacheable(value={"http://rice.kuali.org/krms/v2_0/KrmsAttributionDefinitionType"}, key="'namespaceCode=' + #p0 + '|' + 'name=' + #p1")
    public KrmsAttributeDefinition getAttributeDefinitionByName(@WebParam(name="namespaceCode") String var1, @WebParam(name="name") String var2) throws RiceIllegalArgumentException;
}

