/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;

public final class NaturalLanguageUsageGenTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<naturalLanguageUsage xmlns=\"http://rice.kuali.org/krms/v2_0\">\n    <name>NAME</name>\n    <namespace>NAMESPACE</namespace>\n    <id>ID</id>\n    <active>false</active>\n</naturalLanguageUsage>";
    private static final boolean ACTIVE = false;
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String ID = "ID";
    private static final String NAME = "NAME";
    private static final String NAMESPACE = "NAMESPACE";
    private static final Long VERSION_NUMBER = 0L;

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_Builder_create_fail_all_null() {
        NaturalLanguageUsage.Builder.create(null, null);
    }

    @Test
    public void test_NaturalLanguageUsage_set_validation_id_success_null() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_id_fail_empty() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_id_fail_whitespace() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_name_fail_null() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_name_fail_empty() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setName("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_name_fail_whitespace() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setName("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_namespace_fail_null() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setNamespace(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_namespace_fail_empty() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setNamespace("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_NaturalLanguageUsage_set_validation_namespace_fail_whitespace() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setNamespace("    ");
    }

    @Test
    public void test_NaturalLanguageUsage_Builder_create() {
        NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
    }

    @Test
    public void test_NaturalLanguageUsage_Builder_create_and_build() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.build();
    }

    @Test
    public void test_NaturalLanguageUsage_xml_marshaling() throws Exception {
        NaturalLanguageUsage naturalLanguageUsage = NaturalLanguageUsageGenTest.buildFullNaturalLanguageUsage();
        this.assertXmlMarshaling(naturalLanguageUsage, XML);
    }

    public void assertXmlMarshaling(Object naturalLanguageUsage, String expectedXml) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{NaturalLanguageUsage.class});
        Marshaller marshaller = jc.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(naturalLanguageUsage, (Writer)stringWriter);
        String xml = stringWriter.toString();
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object actual = unmarshaller.unmarshal((Reader)new StringReader(xml));
        Object expected = unmarshaller.unmarshal((Reader)new StringReader(expectedXml));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static NaturalLanguageUsage buildFullNaturalLanguageUsage() {
        NaturalLanguageUsage.Builder builder = NaturalLanguageUsage.Builder.create((String)NAME, (String)NAMESPACE);
        builder.setId(ID);
        NaturalLanguageUsage naturalLanguageUsage = builder.build();
        return naturalLanguageUsage;
    }
}

