/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.KrmsTypeGenTest;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;

public final class TypeTypeRelationGenTest {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<typeTypeRelation>\n    <fromTypeId>ID</fromTypeId>\n    <toTypeId>ID</toTypeId>\n    <relationshipType>UNKNOWN</relationshipType>\n    <sequenceNumber>-1</sequenceNumber>\n    <id>ID</id>\n    <active>false</active>\n</typeTypeRelation>";
    private static final boolean ACTIVE = false;
    private static final String FROM_TYPE_ID = "FROM_TYPE_ID";
    private static final String ID = "ID";
    private static final RelationshipType RELATIONSHIP_TYPE = RelationshipType.UNKNOWN;
    private static final Integer SEQUENCE_NUMBER = -1;
    private static final String TO_TYPE_ID = "TO_TYPE_ID";
    private static final Long VERSION_NUMBER = 0L;

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_Builder_create_fail_all_null() {
        TypeTypeRelation.Builder.create(null, null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_fromTypeId_fail_null() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setFromTypeId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_fromTypeId_fail_empty() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setFromTypeId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_fromTypeId_fail_whitespace() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setFromTypeId("    ");
    }

    @Test
    public void test_TypeTypeRelation_set_validation_id_success_null() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_id_fail_empty() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_id_fail_whitespace() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setId("    ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_relationshipType_fail_null() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setRelationshipType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_sequenceNumber_fail_null() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setSequenceNumber(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_toTypeId_fail_null() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setToTypeId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_toTypeId_fail_empty() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setToTypeId("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_TypeTypeRelation_set_validation_toTypeId_fail_whitespace() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.setToTypeId("    ");
    }

    @Test
    public void test_TypeTypeRelation_Builder_create() {
        TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
    }

    @Test
    public void test_TypeTypeRelation_Builder_create_and_build() {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)FROM_TYPE_ID, (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)TO_TYPE_ID);
        builder.build();
    }

    @Test
    public void test_TypeTypeRelation_xml_marshaling() throws Exception {
        TypeTypeRelation typeTypeRelation = TypeTypeRelationGenTest.buildFullTypeTypeRelation();
        this.assertXmlMarshaling(typeTypeRelation, XML);
    }

    public void assertXmlMarshaling(Object typeTypeRelation, String expectedXml) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{TypeTypeRelation.class});
        Marshaller marshaller = jc.createMarshaller();
        StringWriter stringWriter = new StringWriter();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal(typeTypeRelation, (Writer)stringWriter);
        String xml = stringWriter.toString();
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object actual = unmarshaller.unmarshal((Reader)new StringReader(xml));
        Object expected = unmarshaller.unmarshal((Reader)new StringReader(expectedXml));
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public static TypeTypeRelation buildFullTypeTypeRelation() {
        KrmsTypeDefinition fromType = KrmsTypeGenTest.buildFullKrmsType();
        KrmsTypeDefinition toType = KrmsTypeGenTest.buildFullKrmsType();
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)fromType.getId(), (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)toType.getId());
        builder.setId(ID);
        TypeTypeRelation typeTypeRelation = builder.build();
        return typeTypeRelation;
    }

    public static TypeTypeRelation buildFullFKTypeTypeRelation(KrmsTypeDefinition fromType, KrmsTypeDefinition toType) {
        TypeTypeRelation.Builder builder = TypeTypeRelation.Builder.create((String)fromType.getId(), (RelationshipType)RELATIONSHIP_TYPE, (Integer)SEQUENCE_NUMBER, (String)toType.getId());
        builder.setId(ID);
        TypeTypeRelation typeTypeRelation = builder.build();
        return typeTypeRelation;
    }
}

