/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttributeContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="KRMSType")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KRMSTypeType", propOrder={"id", "name", "namespace", "serviceName", "active", "attributes", "versionNumber", "_futureElements"})
public final class KrmsTypeDefinition
extends AbstractDataTransferObject
implements KrmsTypeDefinitionContract {
    private static final long serialVersionUID = -8314397393380856301L;
    @XmlElement(name="id", required=false)
    private String id;
    @XmlElement(name="name", required=true)
    private String name;
    @XmlElement(name="namespace", required=true)
    private String namespace;
    @XmlElement(name="serviceName", required=false)
    private String serviceName;
    @XmlElement(name="active", required=false)
    private boolean active;
    @XmlElement(name="attribute", required=false)
    private List<KrmsTypeAttribute> attributes;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KrmsTypeDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.serviceName = null;
        this.active = true;
        this.attributes = null;
        this.versionNumber = null;
    }

    private KrmsTypeDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespace = builder.getNamespace();
        this.serviceName = builder.getServiceName();
        this.active = builder.isActive();
        this.attributes = ModelObjectUtils.buildImmutableCopy((List)builder.attributes);
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<KrmsTypeAttribute> getAttributes() {
        return this.attributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/KRMSTypeType";
    }

    public static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String NAMESPACE = "namespace";
        static final String SERVICENAME = "serviceName";
        static final String ACTIVE = "active";
        static final String ATTRIBUTE = "attribute";
        static final String ATTRIBUTES = "attributes";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "KRMSType";
        static final String TYPE_NAME = "KRMSTypeType";

        Constants() {
        }
    }

    public static class Builder
    implements KrmsTypeDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -3469525730879441547L;
        private String id;
        private String name;
        private String namespace;
        private String serviceName = "";
        private boolean active;
        private List<KrmsTypeAttribute.Builder> attributes;
        private Long versionNumber;

        private Builder(String name, String namespace) {
            this.setName(name);
            this.setNamespace(namespace);
            this.setActive(true);
            this.setAttributes(new ArrayList<KrmsTypeAttribute.Builder>());
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder attributes(List<KrmsTypeAttribute.Builder> attributes) {
            this.setAttributes(attributes);
            return this;
        }

        public static Builder create(String name, String namespace) {
            return new Builder(name, namespace);
        }

        public static Builder create(KrmsTypeDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getName(), contract.getNamespace());
            builder.setId(contract.getId());
            builder.setNamespace(contract.getNamespace());
            builder.setActive(contract.isActive());
            builder.setServiceName(contract.getServiceName());
            ArrayList<KrmsTypeAttribute.Builder> attrBuilderList = new ArrayList<KrmsTypeAttribute.Builder>();
            if (contract.getAttributes() != null) {
                for (KrmsTypeAttributeContract krmsTypeAttributeContract : contract.getAttributes()) {
                    KrmsTypeAttribute.Builder myBuilder = KrmsTypeAttribute.Builder.create(krmsTypeAttributeContract);
                    attrBuilderList.add(myBuilder);
                }
            }
            builder.setAttributes(attrBuilderList);
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String id) {
            if (id != null && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("ID must be non-blank");
            }
            this.id = id;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace is blank");
            }
            this.namespace = namespace;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public void setAttributes(List<KrmsTypeAttribute.Builder> attributes) {
            this.attributes = attributes;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getServiceName() {
            return this.serviceName;
        }

        public List<KrmsTypeAttribute.Builder> getAttributes() {
            return this.attributes;
        }

        public boolean isActive() {
            return this.active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public KrmsTypeDefinition build() {
            return new KrmsTypeDefinition(this);
        }
    }
}

