/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.agenda;

import java.util.Map;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * Agenda Definition Contract
 *
 * @see AgendaDefinition
 */
public interface AgendaDefinitionContract extends Identifiable, Inactivatable, Versioned {
	/**
	 * Returns the name of the Agenda.
	 *
	 * @return the name of the Agenda
	 */
	public String getName();

	/**
	 * Returns the KRMS type id of the Agenda.
	 *
	 * @return id for KRMS type related of the agenda
	 */
	public String getTypeId();
	
	/**
	 * Returns the context id of the Agenda.
	 *
	 * @return id for context relative to the agenda
	 */	
	public String getContextId();
	
	/**
	 * Returns the fist agenda item id to be executed in the Agenda.
     * (Also known as the root of the agenda item / rules tree.)
	 *
	 * @return id of the first agenda item id of the agenda.
	 */	
	public String getFirstItemId();
	
	/**
	 * This method returns a list of custom/remote attributes associated with the
	 * agenda.
	 * 
	 * @return a list of custom/remote attribute of the agenda.
	 */
	public Map<String, String> getAttributes();
	
}
