/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.proposition;


import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.krms.api.repository.term.TermDefinition;

/**
 * The contract for {@link PropositionParameter}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface PropositionParameterContract extends Identifiable, Versioned {
	/**
	 * Returns the Id for the parent proposition.
	 *
	 * <p>
	 * It is the Id of the parent proposition.
	 * </p>
	 * @return Id for parent parameter.
	 */
	public String getPropId();

	
	/**
	 * Returns the value of the proposition parameter
	 *
	 * <p>
	 * It is the value of the parameter
	 * </p>
	 * @return value of the parameter
	 */
	public String getValue();

        
	/**
	 * Returns the term value of the proposition parameter if the 
         * proposition parameter is a term.
	 *
	 * <p>
	 * It is the term value of the parameter
	 * </p>
	 * @return value of the term parameter
	 */
	public TermDefinition getTermValue();
        
	/**
	 * Returns the type of the parameter.
	 * Proposition parameters are one of the following types:
	 *    Constant Values:  numbers, strings, dates, etc.
	 *    Terms: data available in the execution environment or provided by a term resolver
	 *    Functions: custom functions that resolve to a value, 
	 *    	or standard operators (equals, greater than, less than, ...)
	 *
	 * <p>
	 * It identified the type of the parameter.
	 * </p>
	 * @return the parameter type code. Valid values are C, T, and F.
	 */
	public String getParameterType();

	/**
	 * Returns the sequence number of the proposition parameter.
	 * Proposition parameters are listed in Reverse Polish Notation.
	 * The sequence number (starting with 1) identifies the position of the 
	 * parameter in the list.
	 * 
	 * @return the sequence number of the proposition parameter
	 */
	public Integer getSequenceNumber();
}
