/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.engine.expression;

import org.kuali.rice.krms.api.KrmsConstants;
import org.kuali.rice.krms.framework.engine.expression.EngineComparatorExtension;
import org.kuali.rice.krms.framework.engine.expression.StringCoercionExtension;

import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import java.util.List;

/**
 * Interface for registering {@link EngineComparatorExtension} for use as a
 * {@link org.kuali.rice.krms.framework.engine.expression.ComparisonOperator} when comparing
 * {@link org.kuali.rice.krms.framework.engine.Proposition} {@link Term}s
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@WebService(name = "comparisonOperatorService", targetNamespace = KrmsConstants.Namespaces.KRMS_NAMESPACE_2_0)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
public interface ComparisonOperatorService extends StringCoercionExtension {

    /**
     * The {@link List} of {@link EngineComparatorExtension}s.
     * @return List&lt;EngineComparatorExtension&gt; of configured {@link EngineComparatorExtension}s.
     */
    public List<EngineComparatorExtension> getOperators();

    /**
     * List&lt;EngineComparatorExtension&gt; to use.
     */
    public void setOperators(List<EngineComparatorExtension> operators);

    @Override
    @WebMethod(operationName = "canCoerce")
    @WebResult(name = "coerced")
    public boolean canCoerce(String type, String value);

    @Override
    @WebMethod(operationName = "coerce")
    @WebResult(name = "coerced")
    public Object coerce(String type, String value);

    /**
     * Returns the int result of a compare between the lhs and rhs objects.
     * @param lhs left hand side object
     * @param rhs right hand side object
     * @return int result of compare between lhs and rhs objects
     */
    public int compare(Object lhs, Object rhs);

    /**
     * Does the service have an Extension that can compare the given objects?
     *
     * @param leftHandSide left hand side Object
     * @param rightHandSide right hand side Object
     * @return boolean true a configured {@link EngineComparatorExtension} can compare the lhs and rhs Objects.
     */
    public boolean canCompare(Object leftHandSide, Object rightHandSide);

    /**
     * {@link EngineComparatorExtension} that canCompare the given Objects
     * @param leftHandSide left hand side Object
     * @param rightHandSide right hand side Object
     * @return the EngineComparatorExtension that can compare the given Objects.
     */
    public EngineComparatorExtension findComparatorExtension(Object leftHandSide, Object rightHandSide);

    /**
     *
     * @return List&lt;StringCoercionExtension&gt;
     */
    // this would move to a StringCoercionExtensionService if we go that way
    public List<StringCoercionExtension> getStringCoercionExtensions();

    /**
     * The {@link List} of {@link StringCoercionExtension}s.
     */
    // this would move to a StringCoercionExtensionService if we go that way
    public void setStringCoercionExtensions(List<StringCoercionExtension> stringCoercionExtensions);

    /**
     *
     * @param type to coerce
     * @param value to coerce
     * @return {@link StringCoercionExtension} that can coerce the given type and value
     */
    // this would move to a StringCoercionExtensionService if we go that way
    StringCoercionExtension findStringCoercionExtension(String type, String value);

}
