/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.term;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 * <p>The contract for a {@link TermParameterDefinition} which defines a term parameter.  This is simply
 * a name and a value that is associated with a term by an identifier.
 * </p>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see TermParameterDefinition
 */
public interface TermParameterDefinitionContract extends Identifiable, Versioned {

    /**
     * Gets the identifier for the term that this parameter belongs to.  May be null, must not be empty.
     *
     * @return the term identifier
     */
	String getTermId();

    /**
     * Gets the name of this parameter.  Must not be null or empty.
     *
     * @return the name of this parameter
     */
	String getName();

    /**
     * Gets the value of this parameter.  May be null.
     *
     * @return the value of this parameter
     */
	String getValue();

}
