/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.kuali.rice.krms.api.repository;

import java.util.List;

/**
 * Natural Language representation of a proposition
 * 
 * @see NaturalLanguageTree
 */
public interface NaturalLanguageTreeContract {

    /**
     * Returns the natural language representation for this node in the tree
     * 
     * @return the natural language representation for this node in the tree
     */
    String getNaturalLanguage();
    
    /**
     * Returns the natural language for children of this node
     * 
     * @return the natural language for children of this node
     */
    List<? extends NaturalLanguageTreeContract> getChildren();

    
}
