/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.typerelation;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * Defines the contract for a {@link TypeTypeRelation}
 *
 * @see TypeTypeRelation
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface TypeTypeRelationContract extends Identifiable, Inactivatable, Versioned {
    /**
     * This is the FromTypeId of the TypeTypeRelation
     * <p>
     * The FromTypeId of the TypeTypeRelation
     * </p>
     * @return the FromTypeId of the TypeTypeRelation
     */
    String getFromTypeId();
    /**
     * This is the ToTypeId of the TypeTypeRelation
     * <p>
     * The ToTypeId of the TypeTypeRelation
     * </p>
     * @return the ToTypeId of the TypeTypeRelation
     */
    String getToTypeId();
    /**
     * This is the RelationshipType of the TypeTypeRelation
     * <p>
     * The RelationshipType of the TypeTypeRelation
     * </p>
     * @return the RelationshipType of the TypeTypeRelation
     */
    RelationshipType getRelationshipType();

    Integer getSequenceNumber();
}
