/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.operator;

import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;

import java.util.List;

/**
 * A service that can export a custom function as an operator in the KRMS rule editor user interface.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface CustomOperator {

    /**
     * gets the {@link org.kuali.rice.krms.api.repository.function.FunctionDefinition} for the function that will be
     * evaluated at rule execution time.  Note that the backing FunctionTypeService must be locally available to the
     * application at execution time, as execution objects in KRMS can not be obtained over the service bus.
     *
     * The FunctionDefinition returned by this method must have a return type of java.lang.Boolean, and must have
     * either one or two FunctionParameterDefinitions.
     *
     * @return a FunctionDefinition with a return type of Boolean
     */
    FunctionDefinition getOperatorFunctionDefinition();

    /**
     * Validates that the given operand classes are acceptable for the custom function.
     *
     * <p>Note that the attribute name in returned errors will be ignored.</p>
     * <p>If only a single operand has been specified, then rhsClassName will be null.</p>
     *
     * @param lhsClassName the class name for the left hand side operand
     * @param rhsClassName the class name for the right hand side operand
     * @return A list of errors, or an empty list if no errors are found
     */
    List<RemotableAttributeError> validateOperandClasses(String lhsClassName, String rhsClassName);
}
