/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.kuali.rice.core.api.mo.common.Coded;
import org.kuali.rice.core.api.util.jaxb.EnumStringAdapter;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.expression.ComparisonOperatorService;

public enum ComparisonOperator implements Coded
{
    EQUALS("="),
    NOT_EQUALS("!="),
    GREATER_THAN(">"),
    GREATER_THAN_EQUAL(">="),
    LESS_THAN("<"),
    LESS_THAN_EQUAL("<="),
    EXISTS("!=null"),
    DOES_NOT_EXIST("=null");

    private final String code;
    ComparisonOperatorService comparisonOperatorService;
    public static final Collection<String> OPERATOR_CODES;
    public static final Collection<String> OPERATOR_NAMES;

    private ComparisonOperator(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static ComparisonOperator fromCode(String code) {
        if (code == null) {
            return null;
        }
        for (ComparisonOperator comparisonOperator : ComparisonOperator.values()) {
            if (!comparisonOperator.code.equals(code)) continue;
            return comparisonOperator;
        }
        throw new IllegalArgumentException("Failed to locate the ComparisionOperator with the given code: " + code);
    }

    public boolean compare(Object lhs, Object rhs) {
        if (this.comparisonOperatorService == null) {
            this.setComparisonOperatorService(KrmsApiServiceLocator.getComparisonOperatorService());
        }
        int result = this.comparisonOperatorService.compare(lhs, rhs);
        if (this == EQUALS) {
            return result == 0;
        }
        if (this == NOT_EQUALS) {
            return result != 0;
        }
        if (this == GREATER_THAN) {
            return result > 0;
        }
        if (this == GREATER_THAN_EQUAL) {
            return result >= 0;
        }
        if (this == LESS_THAN) {
            return result < 0;
        }
        if (this == LESS_THAN_EQUAL) {
            return result <= 0;
        }
        if (this == EXISTS) {
            return rhs != null;
        }
        if (this == DOES_NOT_EXIST) {
            return rhs == null;
        }
        throw new IllegalStateException("Invalid comparison operator detected: " + (Object)((Object)this));
    }

    public void setComparisonOperatorService(ComparisonOperatorService comparisonOperatorService) {
        this.comparisonOperatorService = comparisonOperatorService;
    }

    public String toString() {
        return this.code;
    }

    static {
        OPERATOR_CODES = Collections.unmodifiableCollection(Arrays.asList(EQUALS.getCode(), NOT_EQUALS.getCode(), GREATER_THAN.getCode(), GREATER_THAN_EQUAL.getCode(), LESS_THAN.getCode(), LESS_THAN_EQUAL.getCode()));
        OPERATOR_NAMES = Collections.unmodifiableCollection(Arrays.asList(EQUALS.name(), NOT_EQUALS.name(), GREATER_THAN.name(), GREATER_THAN_EQUAL.name(), LESS_THAN.name(), LESS_THAN_EQUAL.name()));
    }

    static final class Adapter
    extends EnumStringAdapter<ComparisonOperator> {
        Adapter() {
        }

        protected Class<ComparisonOperator> getEnumClass() {
            return ComparisonOperator.class;
        }
    }
}

