/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.framework.ActionMock;
import org.kuali.rice.krms.framework.ManualContextProvider;
import org.kuali.rice.krms.framework.TermResolverMock;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.AgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicAgenda;
import org.kuali.rice.krms.framework.engine.BasicAgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicContext;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.kuali.rice.krms.framework.engine.ComparableTermBasedProposition;
import org.kuali.rice.krms.framework.engine.Context;
import org.kuali.rice.krms.framework.engine.ContextProvider;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.ProviderBasedEngine;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperatorServiceImpl;

@Ignore
public class AgendaTest {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private ComparisonOperator operatorGreaterThan;
    private Proposition trueProp;
    private Proposition falseProp;
    private static final Term totalCostTerm = new Term("totalCost");
    private static final TermResolver<Integer> testResolver = new TermResolverMock<Integer>(totalCostTerm.getName(), 10);

    @Before
    public void setUp() {
        this.operatorGreaterThan = ComparisonOperator.GREATER_THAN;
        this.operatorGreaterThan.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        this.trueProp = new ComparableTermBasedProposition(this.operatorGreaterThan, totalCostTerm, (Object)1);
        this.falseProp = new ComparableTermBasedProposition(this.operatorGreaterThan, totalCostTerm, (Object)1000);
        ActionMock.resetActionsFired();
    }

    @Test
    public void testAllRulesAgenda() {
        BasicRule rule1 = new BasicRule("r1", this.trueProp, Collections.singletonList(new ActionMock("a1")));
        BasicRule rule2 = new BasicRule("r2", this.falseProp, Collections.singletonList(new ActionMock("a2")));
        BasicRule rule3 = new BasicRule("r3", this.trueProp, Collections.singletonList(new ActionMock("a3")));
        BasicAgendaTreeEntry entry1 = new BasicAgendaTreeEntry((Rule)rule1);
        BasicAgendaTreeEntry entry2 = new BasicAgendaTreeEntry((Rule)rule2);
        BasicAgendaTreeEntry entry3 = new BasicAgendaTreeEntry((Rule)rule3);
        BasicAgendaTree agendaTree = new BasicAgendaTree(new AgendaTreeEntry[]{entry1, entry2, entry3});
        BasicAgenda agenda = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree);
        this.execute((Agenda)agenda);
        Assert.assertTrue((boolean)ActionMock.actionFired("a1"));
        Assert.assertFalse((boolean)ActionMock.actionFired("a2"));
        Assert.assertTrue((boolean)ActionMock.actionFired("a3"));
    }

    @Test
    public void testIfTrueSubAgenda() {
        BasicRule rule1 = new BasicRule("r1", this.trueProp, Collections.singletonList(new ActionMock("a1")));
        BasicRule rule2 = new BasicRule("r2", this.falseProp, Collections.singletonList(new ActionMock("a2")));
        BasicRule subRule1 = new BasicRule("r1s1", this.trueProp, Collections.singletonList(new ActionMock("a3")));
        BasicAgendaTree subAgendaTree1 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)subRule1)});
        BasicAgendaTree agendaTree1 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule1, (AgendaTree)subAgendaTree1, null)});
        BasicAgenda agenda1 = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree1);
        this.execute((Agenda)agenda1);
        Assert.assertTrue((boolean)ActionMock.actionFired("a1"));
        Assert.assertTrue((boolean)ActionMock.actionFired("a3"));
        ActionMock.resetActionsFired();
        BasicAgendaTree subAgendaTree2 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)subRule1)});
        BasicAgendaTree agendaTree2 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule2, (AgendaTree)subAgendaTree2, null)});
        BasicAgenda agenda2 = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree2);
        this.execute((Agenda)agenda2);
        Assert.assertFalse((boolean)ActionMock.actionFired("a2"));
        Assert.assertFalse((boolean)ActionMock.actionFired("a3"));
    }

    @Test
    public void testIfFalseSubAgenda() {
        BasicRule rule1 = new BasicRule("r1", this.trueProp, Collections.singletonList(new ActionMock("a1")));
        BasicRule rule2 = new BasicRule("r2", this.falseProp, Collections.singletonList(new ActionMock("a2")));
        BasicRule subRule1 = new BasicRule("r1s1", this.trueProp, Collections.singletonList(new ActionMock("a3")));
        BasicAgendaTree subAgendaTree1 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)subRule1)});
        BasicAgendaTree agendaTree1 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule1, null, (AgendaTree)subAgendaTree1)});
        BasicAgenda agenda1 = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree1);
        this.execute((Agenda)agenda1);
        Assert.assertTrue((boolean)ActionMock.actionFired("a1"));
        Assert.assertFalse((boolean)ActionMock.actionFired("a3"));
        ActionMock.resetActionsFired();
        BasicAgendaTree subAgendaTree2 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)subRule1)});
        BasicAgendaTree agendaTree2 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule2, null, (AgendaTree)subAgendaTree2)});
        BasicAgenda agenda2 = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree2);
        this.execute((Agenda)agenda2);
        Assert.assertFalse((boolean)ActionMock.actionFired("a2"));
        Assert.assertTrue((boolean)ActionMock.actionFired("a3"));
    }

    @Test
    public void testAfterAgenda() {
        BasicRule rule1 = new BasicRule("r1", this.trueProp, Collections.singletonList(new ActionMock("a1")));
        BasicRule rule2 = new BasicRule("r2", this.falseProp, Collections.singletonList(new ActionMock("a2")));
        BasicRule subRule1 = new BasicRule("r1s1", this.trueProp, Collections.singletonList(new ActionMock("a3")));
        BasicAgendaTree agendaTree1 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule1), new BasicAgendaTreeEntry((Rule)subRule1)});
        BasicAgenda agenda1 = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree1);
        this.execute((Agenda)agenda1);
        Assert.assertTrue((boolean)ActionMock.actionFired("a1"));
        Assert.assertTrue((boolean)ActionMock.actionFired("a3"));
        ActionMock.resetActionsFired();
        BasicAgendaTree agendaTree2 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule2), new BasicAgendaTreeEntry((Rule)subRule1)});
        BasicAgenda agenda2 = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree2);
        this.execute((Agenda)agenda2);
        Assert.assertFalse((boolean)ActionMock.actionFired("a2"));
        Assert.assertTrue((boolean)ActionMock.actionFired("a3"));
    }

    public void testQualifierMissingFromAgenda() {
        ActionMock.resetActionsFired();
        BasicRule rule1 = new BasicRule("r1", this.trueProp, Collections.singletonList(new ActionMock("a1")));
        BasicAgendaTree agendaTree1 = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule1)});
        BasicAgenda agenda1 = new BasicAgenda(Collections.emptyMap(), (AgendaTree)agendaTree1);
        this.execute((Agenda)agenda1, Collections.singletonMap("Event", "test"));
        Assert.assertFalse((String)"the agenda should not have been selected and executed", (boolean)ActionMock.actionFired("a1"));
    }

    private void execute(Agenda agenda) {
        this.execute(agenda, Collections.singletonMap("Event", "test"));
    }

    private void execute(Agenda agenda, Map<String, String> agendaQualifiers) {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("docTypeName", "Proposal");
        ArrayList<TermResolver<Integer>> testResolvers = new ArrayList<TermResolver<Integer>>();
        testResolvers.add(testResolver);
        BasicContext context = new BasicContext(Arrays.asList(agenda), testResolvers);
        ManualContextProvider contextProvider = new ManualContextProvider((Context)context);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, agendaQualifiers);
        ProviderBasedEngine engine = new ProviderBasedEngine();
        engine.setContextProvider((ContextProvider)contextProvider);
        ExecutionOptions executionOptions = new ExecutionOptions().setFlag(ExecutionFlag.LOG_EXECUTION, true);
        EngineResults results = engine.execute(selectionCriteria, Facts.EMPTY_FACTS, executionOptions);
        Assert.assertNotNull((Object)results);
    }
}

