/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.framework.ActionMock;
import org.kuali.rice.krms.framework.ManualContextProvider;
import org.kuali.rice.krms.framework.TermResolverMock;
import org.kuali.rice.krms.framework.engine.Agenda;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.AgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicAgenda;
import org.kuali.rice.krms.framework.engine.BasicAgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicContext;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.kuali.rice.krms.framework.engine.CollectionOfComparablesTermBasedProposition;
import org.kuali.rice.krms.framework.engine.CollectionOperator;
import org.kuali.rice.krms.framework.engine.Context;
import org.kuali.rice.krms.framework.engine.ContextProvider;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.ProviderBasedEngine;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperatorServiceImpl;

public class CollectionOfComparablesTermBasedPropositionTest {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private ComparisonOperator operatorGreaterThan;

    @Before
    public void setUp() {
        this.operatorGreaterThan = ComparisonOperator.GREATER_THAN;
        this.operatorGreaterThan.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        ActionMock.resetActionsFired();
    }

    @Test
    public void allPropositionTest() {
        this.assertRuleTrue(Arrays.asList(Float.valueOf(100.0f), Float.valueOf(1000.0f)), CollectionOperator.ALL, this.operatorGreaterThan, Float.valueOf(1.0f));
        this.assertRuleTrue(Arrays.asList(Float.valueOf(100.0f)), CollectionOperator.ALL, this.operatorGreaterThan, Float.valueOf(1.0f));
        this.assertRuleTrue(Arrays.asList(new Float[0]), CollectionOperator.ALL, this.operatorGreaterThan, Float.valueOf(1.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(100.0f), Float.valueOf(1000.0f)), CollectionOperator.ALL, this.operatorGreaterThan, Float.valueOf(10000.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(100.0f), Float.valueOf(1000.0f)), CollectionOperator.ALL, this.operatorGreaterThan, Float.valueOf(500.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(1000.0f), Float.valueOf(100.0f)), CollectionOperator.ALL, this.operatorGreaterThan, Float.valueOf(500.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(100.0f)), CollectionOperator.ALL, this.operatorGreaterThan, Float.valueOf(10000.0f));
    }

    @Test
    public void oneOrMorePropositionTest() {
        this.assertRuleTrue(Arrays.asList(Float.valueOf(100.0f), Float.valueOf(1000.0f)), CollectionOperator.ONE_OR_MORE, this.operatorGreaterThan, Float.valueOf(500.0f));
        this.assertRuleTrue(Arrays.asList(Float.valueOf(1000.0f), Float.valueOf(100.0f)), CollectionOperator.ONE_OR_MORE, this.operatorGreaterThan, Float.valueOf(500.0f));
        this.assertRuleTrue(Arrays.asList(Float.valueOf(1000.0f)), CollectionOperator.ONE_OR_MORE, this.operatorGreaterThan, Float.valueOf(500.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(1000.0f), Float.valueOf(2000.0f)), CollectionOperator.ONE_OR_MORE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(2000.0f), Float.valueOf(1000.0f)), CollectionOperator.ONE_OR_MORE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(1000.0f)), CollectionOperator.ONE_OR_MORE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleFalse(Arrays.asList(new Float[0]), CollectionOperator.ONE_OR_MORE, this.operatorGreaterThan, Float.valueOf(5000.0f));
    }

    @Test
    public void nonePropositionTest() {
        this.assertRuleTrue(Arrays.asList(Float.valueOf(100.0f), Float.valueOf(1000.0f)), CollectionOperator.NONE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleTrue(Arrays.asList(Float.valueOf(1000.0f)), CollectionOperator.NONE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleTrue(Arrays.asList(new Float[0]), CollectionOperator.NONE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(1000.0f), Float.valueOf(7000.0f)), CollectionOperator.NONE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(7000.0f), Float.valueOf(1000.0f)), CollectionOperator.NONE, this.operatorGreaterThan, Float.valueOf(5000.0f));
        this.assertRuleFalse(Arrays.asList(Float.valueOf(7000.0f)), CollectionOperator.NONE, this.operatorGreaterThan, Float.valueOf(5000.0f));
    }

    private void execute(Agenda agenda, TermResolver ... termResolvers) {
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("docTypeName", "Proposal");
        List<TermResolver> testResolvers = Arrays.asList(termResolvers);
        BasicContext context = new BasicContext(Arrays.asList(agenda), testResolvers);
        ManualContextProvider contextProvider = new ManualContextProvider((Context)context);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Event", "test"));
        ProviderBasedEngine engine = new ProviderBasedEngine();
        engine.setContextProvider((ContextProvider)contextProvider);
        ExecutionOptions executionOptions = new ExecutionOptions().setFlag(ExecutionFlag.LOG_EXECUTION, true);
        EngineResults results = engine.execute(selectionCriteria, Facts.EMPTY_FACTS, executionOptions);
        Assert.assertNotNull((Object)results);
    }

    private void assertRuleTrue(List<Float> termValue, CollectionOperator collectionOper, ComparisonOperator comparisonOper, Float compareValue) {
        this.assertRule(termValue, collectionOper, comparisonOper, compareValue, true);
    }

    private void assertRuleFalse(List<Float> termValue, CollectionOperator collectionOper, ComparisonOperator comparisonOper, Float compareValue) {
        this.assertRule(termValue, collectionOper, comparisonOper, compareValue, false);
    }

    private void assertRule(List<Float> termValue, CollectionOperator collectionOper, ComparisonOperator comparisonOper, Float compareValue, boolean assertTrue) {
        boolean actionFired = this.executeTestAgenda(termValue, collectionOper, comparisonOper, compareValue).actionFired();
        if (assertTrue) {
            Assert.assertTrue((boolean)actionFired);
        } else {
            Assert.assertFalse((boolean)actionFired);
        }
        ActionMock.resetActionsFired();
    }

    private ActionMock executeTestAgenda(List<Float> termValue, CollectionOperator collectionOper, ComparisonOperator comparisonOper, Float compareValue) {
        Term expensesTerm = new Term("expenses");
        TermResolverMock<List<Float>> expensesResolver = new TermResolverMock<List<Float>>(expensesTerm.getName(), termValue);
        CollectionOfComparablesTermBasedProposition prop1 = new CollectionOfComparablesTermBasedProposition(collectionOper, comparisonOper, expensesTerm, (Object)compareValue);
        ActionMock prop1Action = new ActionMock("prop1Action");
        BasicRule rule = new BasicRule("ALL", (Proposition)prop1, Collections.singletonList(prop1Action));
        BasicAgendaTree agendaTree = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule)});
        BasicAgenda agenda = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree);
        this.execute((Agenda)agenda, expensesResolver);
        return prop1Action;
    }
}

