/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.engine.EngineResults;
import org.kuali.rice.krms.api.engine.ExecutionFlag;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolver;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.framework.ManualContextProvider;
import org.kuali.rice.krms.framework.SayHelloAction;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.AgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicAgenda;
import org.kuali.rice.krms.framework.engine.BasicAgendaTree;
import org.kuali.rice.krms.framework.engine.BasicAgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.BasicContext;
import org.kuali.rice.krms.framework.engine.BasicRule;
import org.kuali.rice.krms.framework.engine.ComparableTermBasedProposition;
import org.kuali.rice.krms.framework.engine.CompoundProposition;
import org.kuali.rice.krms.framework.engine.Context;
import org.kuali.rice.krms.framework.engine.ContextProvider;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.ProviderBasedEngine;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperatorServiceImpl;

public class ResultLoggingTest {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private static final Term totalCostTerm = new Term("totalCost");
    private static final TermResolver<Integer> testResolver = new TermResolver<Integer>(){

        public int getCost() {
            return 1;
        }

        public String getOutput() {
            return totalCostTerm.getName();
        }

        public Set<String> getPrerequisites() {
            return Collections.emptySet();
        }

        public Set<String> getParameterNames() {
            return Collections.emptySet();
        }

        public Integer resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) {
            return 5;
        }
    };

    @Test
    public void integrationTest() {
        ComparisonOperator greaterThan = ComparisonOperator.GREATER_THAN;
        greaterThan.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        ComparisonOperator lessThan = ComparisonOperator.LESS_THAN;
        lessThan.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        ComparableTermBasedProposition prop1 = new ComparableTermBasedProposition(greaterThan, totalCostTerm, (Object)1);
        ComparableTermBasedProposition prop2 = new ComparableTermBasedProposition(lessThan, totalCostTerm, (Object)1000);
        CompoundProposition compoundProp1 = new CompoundProposition(LogicalOperator.AND, Arrays.asList(prop1, prop2));
        SayHelloAction action1 = new SayHelloAction();
        BasicRule rule = new BasicRule("InBetween", (Proposition)compoundProp1, Arrays.asList(action1));
        BasicAgendaTree agendaTree = new BasicAgendaTree(new AgendaTreeEntry[]{new BasicAgendaTreeEntry((Rule)rule)});
        BasicAgenda agenda = new BasicAgenda(Collections.singletonMap("Event", "test"), (AgendaTree)agendaTree);
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        contextQualifiers.put("docTypeName", "Proposal");
        ArrayList<TermResolver<Integer>> testResolvers = new ArrayList<TermResolver<Integer>>();
        testResolvers.add(testResolver);
        BasicContext context = new BasicContext(Arrays.asList(agenda), testResolvers);
        ManualContextProvider contextProvider = new ManualContextProvider((Context)context);
        SelectionCriteria selectionCriteria = SelectionCriteria.createCriteria(null, contextQualifiers, Collections.singletonMap("Event", "test"));
        ProviderBasedEngine engine = new ProviderBasedEngine();
        engine.setContextProvider((ContextProvider)contextProvider);
        ExecutionOptions executionOptions = new ExecutionOptions().setFlag(ExecutionFlag.LOG_EXECUTION, true);
        EngineResults results = engine.execute(selectionCriteria, Facts.EMPTY_FACTS, executionOptions);
        Assert.assertNotNull((Object)results);
    }
}

