/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.engine.TermResolutionEngine;
import org.kuali.rice.krms.api.engine.TermResolutionException;
import org.kuali.rice.krms.api.engine.TermResolver;

public class TermResolutionEngineImpl
implements TermResolutionEngine {
    private static final Logger LOG = Logger.getLogger(TermResolutionEngineImpl.class);
    private final Map<String, List<TermResolver<?>>> termResolversByOutput = new HashMap();
    private final Map<TermResolverKey, TermResolver<?>> termResolversByKey = new HashMap();
    private final Map<Term, Object> termCache = new HashMap<Term, Object>();

    public void addTermValue(Term term, Object value) {
        this.termCache.put(term, value);
    }

    public void addTermResolver(TermResolver<?> termResolver) {
        if (termResolver == null) {
            throw new IllegalArgumentException("termResolver is reuqired");
        }
        if (termResolver.getOutput() == null) {
            throw new IllegalArgumentException("termResolver.getOutput() must not be null");
        }
        List<TermResolver<?>> termResolvers = this.termResolversByOutput.get(termResolver.getOutput());
        if (termResolvers == null) {
            termResolvers = new LinkedList();
            this.termResolversByOutput.put(termResolver.getOutput(), termResolvers);
        }
        this.termResolversByKey.put(new TermResolverKey(termResolver), termResolver);
        termResolvers.add(termResolver);
    }

    public <T> T resolveTerm(Term term) throws TermResolutionException {
        LOG.debug((Object)("+--> resolveTerm(" + term + ")"));
        if (this.termCache.containsKey(term)) {
            return (T)this.termCache.get(term);
        }
        String termName = term.getName();
        List<TermResolverKey> resolutionPlan = this.buildTermResolutionPlan(termName);
        LOG.debug((Object)("resolutionPlan: " + (resolutionPlan == null ? "null" : StringUtils.join(resolutionPlan.iterator(), (String)", "))));
        if (resolutionPlan != null) {
            LOG.debug((Object)"executing plan");
            for (TermResolverKey resolverKey : resolutionPlan) {
                TermResolver<?> resolver = this.termResolversByKey.get(resolverKey);
                HashMap<String, Object> resolvedPrereqs = new HashMap<String, Object>();
                for (String prereq : resolver.getPrerequisites()) {
                    Object resolvedPrereq = this.termCache.get(new Term(prereq, null));
                    resolvedPrereqs.put(prereq, resolvedPrereq);
                }
                Map providedParameters = Collections.emptyMap();
                if (termName.equals(resolver.getOutput())) {
                    providedParameters = term.getParameters();
                    this.validateTermParameters(resolver, providedParameters);
                }
                Object resolvedTerm = resolver.resolve(resolvedPrereqs, providedParameters);
                if (termName.equals(resolver.getOutput())) {
                    this.termCache.put(term, resolvedTerm);
                    continue;
                }
                if (!CollectionUtils.isEmpty((Collection)resolver.getParameterNames())) {
                    throw new TermResolutionException("TermResolvers requiring parameters cannot be intermediates in the Term resolution plan", resolver, providedParameters);
                }
                this.termCache.put(new Term(resolver.getOutput(), null), resolvedTerm);
            }
        } else {
            throw new TermResolutionException("Unable to plan the resolution of " + term, null, null);
        }
        return (T)this.termCache.get(term);
    }

    private void validateTermParameters(TermResolver<?> resolver, Map<String, String> providedParameters) throws TermResolutionException {
        if (!providedParameters.keySet().equals(resolver.getParameterNames())) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> param : providedParameters.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(param.getKey());
                sb.append("=");
                sb.append(param.getValue());
            }
            throw new TermResolutionException("provided parameters (" + sb + ") do not match requirements (" + StringUtils.join((Collection)resolver.getParameterNames(), (String)",") + ")", resolver, providedParameters);
        }
    }

    protected List<TermResolverKey> buildTermResolutionPlan(String termName) {
        LinkedList<TermResolverKey> resolutionPlan = null;
        HashMap<TermResolverKey, Visited> visitedByKey = new HashMap<TermResolverKey, Visited>();
        PriorityQueue<ToVisit> toVisits = new PriorityQueue<ToVisit>();
        TermResolver<? extends Object> destination = this.createDestination(termName);
        TermResolverKey destinationKey = new TermResolverKey(destination);
        LOG.debug((Object)("Beginning resolution tree search for " + termName));
        toVisits.add(new ToVisit(0, destination, null));
        boolean plannedToDestination = false;
        while (!plannedToDestination && toVisits.size() > 0) {
            ToVisit visiting = (ToVisit)toVisits.poll();
            LOG.debug((Object)("visiting " + visiting.getTermResolverKey()));
            TermResolver resolver = this.getResolver(visiting.getTermResolverKey(), destination, destinationKey);
            TermResolver parent = this.getResolver(visiting.getParentKey(), destination, destinationKey);
            if (visitedByKey.containsKey(visiting.getTermResolverKey())) continue;
            Visited parentVisited = (Visited)visitedByKey.get(visiting.getParentKey());
            if (resolver == null) {
                throw new RuntimeException("Unable to get TermResolver by its key");
            }
            Set prereqs = resolver.getPrerequisites();
            LinkedList<String> metPrereqs = new LinkedList<String>();
            if (prereqs != null) {
                for (String prereq : prereqs) {
                    if (!this.termCache.containsKey(new Term(prereq, null))) {
                        List<TermResolver<?>> prereqResolvers = this.termResolversByOutput.get(prereq);
                        if (prereqResolvers == null) continue;
                        for (TermResolver<?> prereqResolver : prereqResolvers) {
                            if (!CollectionUtils.isEmpty((Collection)prereqResolver.getParameterNames()) && !termName.equals(prereqResolver.getOutput())) continue;
                            toVisits.add(new ToVisit(visiting.getCost(), prereqResolver, resolver));
                        }
                        continue;
                    }
                    metPrereqs.add(prereq);
                }
            }
            Visited visited = this.buildVisited(resolver, parentVisited, metPrereqs);
            visitedByKey.put(visited.getResolverKey(), visited);
            plannedToDestination = this.isPlannedBackToDestination(visited, destinationKey, visitedByKey);
        }
        if (plannedToDestination) {
            resolutionPlan = new LinkedList<TermResolverKey>();
            this.assembleLinearResolutionPlan((Visited)visitedByKey.get(destinationKey), visitedByKey, resolutionPlan);
        }
        return resolutionPlan;
    }

    private Visited buildVisited(TermResolver resolver, Visited parentVisited, Collection<String> metPrereqs) {
        Visited visited = null;
        ArrayList<TermResolverKey> pathTo = new ArrayList<TermResolverKey>(1 + (parentVisited == null ? 0 : parentVisited.pathTo.size()));
        if (parentVisited != null && parentVisited.getPathTo() != null) {
            pathTo.addAll(parentVisited.getPathTo());
        }
        if (parentVisited != null) {
            pathTo.add(parentVisited.getResolverKey());
        }
        TermResolverKey resolverKey = new TermResolverKey(resolver);
        visited = new Visited(resolverKey, pathTo, resolver.getPrerequisites(), resolver.getCost() + (parentVisited == null ? 0 : parentVisited.getCost()));
        for (String metPrereq : metPrereqs) {
            visited.addPlannedPrereq(metPrereq);
        }
        return visited;
    }

    private TermResolver getResolver(TermResolverKey resolverKey, TermResolver destination, TermResolverKey destinationKey) {
        TermResolver<?> resolver = destinationKey.equals(resolverKey) ? destination : this.termResolversByKey.get(resolverKey);
        return resolver;
    }

    private boolean isPlannedBackToDestination(Visited visited, TermResolverKey destinationKey, Map<TermResolverKey, Visited> visitedByKey) {
        boolean plannedToDestination = false;
        if (visited.isFullyPlanned()) {
            LOG.debug((Object)"Leaf! this resolver's prereqs are all avialable.");
            if (visited.getPathTo().size() > 0) {
                ArrayList<TermResolverKey> reversePathTo = new ArrayList<TermResolverKey>(visited.getPathTo());
                Collections.reverse(reversePathTo);
                Visited previousAncestor = visited;
                for (TermResolverKey ancestorKey : reversePathTo) {
                    Visited ancestorVisited = visitedByKey.get(ancestorKey);
                    ancestorVisited.addPlannedPrereq(previousAncestor.getResolverKey());
                    LOG.debug((Object)("checking ancestor " + ancestorKey));
                    if (ancestorVisited.isFullyPlanned() && ancestorKey.equals(destinationKey)) {
                        plannedToDestination = true;
                        break;
                    }
                    if (!ancestorVisited.isFullyPlanned()) {
                        LOG.debug((Object)"Still have planning to do.");
                        break;
                    }
                    previousAncestor = ancestorVisited;
                }
            } else {
                LOG.debug((Object)"Trivial plan.");
                plannedToDestination = true;
            }
        }
        return plannedToDestination;
    }

    private void assembleLinearResolutionPlan(Visited visited, Map<TermResolverKey, Visited> visitedByKey, List<TermResolverKey> plan) {
        for (TermResolverKey prereqResolverKey : visited.getPrereqResolvers()) {
            Visited prereqVisited = visitedByKey.get(prereqResolverKey);
            this.assembleLinearResolutionPlan(prereqVisited, visitedByKey, plan);
            plan.add(prereqResolverKey);
        }
    }

    private TermResolver<? extends Object> createDestination(final String termName) {
        TermResolver<Object> destination = new TermResolver<Object>(){
            final String dest = "termResolutionEngineDestination";

            public int getCost() {
                return 0;
            }

            public String getOutput() {
                return "termResolutionEngineDestination";
            }

            public Set<String> getPrerequisites() {
                return Collections.singleton(termName);
            }

            public Set<String> getParameterNames() {
                return Collections.emptySet();
            }

            public Object resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) throws TermResolutionException {
                return null;
            }
        };
        return destination;
    }

    private static class InvalidResolutionPathException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private static class Visited {
        private TermResolverKey resolverKey;
        private List<TermResolverKey> pathTo;
        private Set<String> remainingPrereqs;
        private Map<String, TermResolverKey> prereqResolvers;
        private int cost;

        public Visited(TermResolverKey resolverKey, List<TermResolverKey> pathTo, Set<String> prereqs, int cost) {
            this.resolverKey = resolverKey;
            this.pathTo = pathTo;
            this.remainingPrereqs = new HashSet<String>(prereqs);
            this.prereqResolvers = new HashMap<String, TermResolverKey>();
            this.cost = cost;
        }

        public List<TermResolverKey> getPathTo() {
            return this.pathTo;
        }

        public TermResolverKey getResolverKey() {
            return this.resolverKey;
        }

        public Collection<TermResolverKey> getPrereqResolvers() {
            return this.prereqResolvers.values();
        }

        public boolean isFullyPlanned() {
            return this.remainingPrereqs.isEmpty();
        }

        public int getCost() {
            return this.cost;
        }

        public void addPlannedPrereq(TermResolverKey termResolverKey) {
            this.remainingPrereqs.remove(termResolverKey.getOutput());
            this.prereqResolvers.put(termResolverKey.getOutput(), termResolverKey);
        }

        public void addPlannedPrereq(String termName) {
            this.remainingPrereqs.remove(termName);
        }
    }

    protected static class TermResolverKey
    implements Comparable<TermResolverKey> {
        private final List<String> data;
        private final String[] params;
        private static final String[] TERM_SPEC_TYPER = new String[0];
        private static final String[] STRING_TYPER = new String[0];

        public TermResolverKey(TermResolver resolver) {
            this(resolver.getOutput(), resolver.getParameterNames(), resolver.getPrerequisites());
        }

        private TermResolverKey(String dest, Set<String> paramSet, Set<String> prereqs) {
            if (dest == null) {
                throw new IllegalArgumentException("dest parameter must not be null");
            }
            this.data = new ArrayList<String>(1 + (prereqs == null ? 0 : prereqs.size()));
            this.data.add(dest);
            if (!CollectionUtils.isEmpty(paramSet)) {
                this.params = paramSet.toArray(STRING_TYPER);
                Arrays.sort(this.params);
            } else {
                this.params = STRING_TYPER;
            }
            if (prereqs != null) {
                Object[] prereqsArray = prereqs.toArray(TERM_SPEC_TYPER);
                Arrays.sort(prereqsArray);
                for (Object prereq : prereqsArray) {
                    this.data.add((String)prereq);
                }
            }
        }

        public String getOutput() {
            return this.data.get(0);
        }

        @Override
        public int compareTo(TermResolverKey o) {
            if (o == null) {
                return 1;
            }
            Iterator<String> mDataIter = this.data.iterator();
            Iterator<String> oDataIter = o.data.iterator();
            while (mDataIter.hasNext() && oDataIter.hasNext()) {
                int itemCompareResult = mDataIter.next().compareTo(oDataIter.next());
                if (itemCompareResult == 0) continue;
                return itemCompareResult;
            }
            if (mDataIter.hasNext()) {
                return 1;
            }
            if (oDataIter.hasNext()) {
                return -1;
            }
            return 0;
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TermResolverKey other = (TermResolverKey)obj;
            return this.compareTo(other) == 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append("(");
            Iterator<String> iter = this.data.iterator();
            sb.append(iter.next().toString());
            if (this.params.length != 0) {
                sb.append("+");
                ArrayUtils.toString((Object)this.params);
            }
            if (iter.hasNext()) {
                sb.append(" <- ");
            }
            boolean first = true;
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(iter.next().toString());
            }
            return sb.toString();
        }
    }

    private static class ToVisit
    implements Comparable<ToVisit> {
        private final int precost;
        private final int addcost;
        private final TermResolverKey resolverKey;
        private final TermResolverKey parentKey;

        public ToVisit(int precost, TermResolver resolver, TermResolver parent) {
            this.precost = precost;
            this.addcost = resolver.getCost();
            this.resolverKey = new TermResolverKey(resolver);
            this.parentKey = parent != null ? new TermResolverKey(parent) : null;
        }

        public int getCost() {
            return this.precost + this.addcost;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ToVisit other = (ToVisit)obj;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getCost();
            result = 31 * result + (this.resolverKey == null ? 0 : this.resolverKey.hashCode());
            return result;
        }

        @Override
        public int compareTo(ToVisit o) {
            if (o == null) {
                return 1;
            }
            if (this.getCost() > o.getCost()) {
                return 1;
            }
            if (this.getCost() < o.getCost()) {
                return -1;
            }
            return this.resolverKey.compareTo(o.resolverKey);
        }

        public TermResolverKey getTermResolverKey() {
            return this.resolverKey;
        }

        public TermResolverKey getParentKey() {
            return this.parentKey;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.getTermResolverKey() + ")";
        }
    }
}

