/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import java.math.BigInteger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperatorServiceImpl;

public class ComparisonOperatorTest {
    @Test
    public void testEquals() {
        ComparisonOperator op = ComparisonOperator.fromCode((String)ComparisonOperator.EQUALS.toString());
        op.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        Assert.assertTrue((boolean)op.compare((Object)"StringOne", (Object)"StringOne"));
        Assert.assertTrue((boolean)op.compare((Object)123, (Object)"123"));
        Assert.assertTrue((boolean)op.compare((Object)BigInteger.TEN, (Object)"10"));
    }

    @Test
    public void testNotEquals() {
        ComparisonOperator op = ComparisonOperator.fromCode((String)ComparisonOperator.NOT_EQUALS.toString());
        op.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        Assert.assertTrue((boolean)op.compare((Object)"StringOne", (Object)"StringTwo"));
        Assert.assertTrue((boolean)op.compare((Object)122, (Object)"123"));
        Assert.assertTrue((boolean)op.compare((Object)BigInteger.TEN, (Object)"11"));
        Assert.assertTrue((boolean)op.compare(null, (Object)"124"));
        Assert.assertFalse((boolean)op.compare(null, null));
    }

    @Test
    public void testLess() {
        ComparisonOperator op = ComparisonOperator.fromCode((String)ComparisonOperator.LESS_THAN.toString());
        op.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        Assert.assertTrue((boolean)op.compare((Object)123, (Object)"124"));
        Assert.assertTrue((boolean)op.compare((Object)new Double(123.2), (Object)"124"));
        Assert.assertTrue((boolean)op.compare(null, (Object)"124"));
        Assert.assertFalse((boolean)op.compare((Object)124, null));
        Assert.assertFalse((boolean)op.compare(null, null));
        Assert.assertFalse((boolean)op.compare((Object)123, (Object)"123"));
        Assert.assertFalse((boolean)op.compare((Object)new Integer(123), (Object)"122"));
        Assert.assertFalse((boolean)op.compare((Object)122.1, (Object)"122"));
    }

    @Test
    public void testLessThanEqual() {
        ComparisonOperator op = ComparisonOperator.fromCode((String)ComparisonOperator.LESS_THAN_EQUAL.toString());
        op.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        Assert.assertTrue((boolean)op.compare((Object)123, (Object)"124"));
        Assert.assertTrue((boolean)op.compare((Object)123.1, (Object)"123.1"));
        Assert.assertTrue((boolean)op.compare(null, null));
        Assert.assertFalse((boolean)op.compare((Object)new Double(123.1), (Object)"123.01"));
        Assert.assertFalse((boolean)op.compare((Object)123, (Object)"122"));
    }

    @Test
    public void testGreaterThanEqual() {
        ComparisonOperator op = ComparisonOperator.fromCode((String)ComparisonOperator.GREATER_THAN_EQUAL.toString());
        op.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        Assert.assertFalse((boolean)op.compare((Object)123, (Object)"124"));
        Assert.assertTrue((boolean)op.compare((Object)123.1, (Object)"123.1"));
        Assert.assertFalse((boolean)op.compare(null, (Object)"124"));
        Assert.assertTrue((boolean)op.compare((Object)124, null));
        Assert.assertTrue((boolean)op.compare(null, null));
        Assert.assertTrue((boolean)op.compare((Object)new Double(123.1), (Object)"123.01"));
        Assert.assertTrue((boolean)op.compare((Object)123, (Object)"122"));
    }

    @Test
    public void testExists() {
        ComparisonOperator op = ComparisonOperator.fromCode((String)ComparisonOperator.EXISTS.toString());
        op.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        Assert.assertTrue((boolean)op.compare((Object)"123", (Object)"0"));
        Assert.assertFalse((boolean)op.compare((Object)"123", null));
    }

    @Test
    public void testDoesNotExists() {
        ComparisonOperator op = ComparisonOperator.fromCode((String)ComparisonOperator.DOES_NOT_EXIST.toString());
        op.setComparisonOperatorService(ComparisonOperatorServiceImpl.getInstance());
        Assert.assertFalse((boolean)op.compare((Object)"123", (Object)"0"));
        Assert.assertTrue((boolean)op.compare((Object)"123", null));
    }
}

