/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.AgendaTree;
import org.kuali.rice.krms.framework.engine.AgendaTreeEntry;
import org.kuali.rice.krms.framework.engine.Rule;

public final class BasicAgendaTreeEntry
implements AgendaTreeEntry {
    private final Rule rule;
    private final AgendaTree ifTrue;
    private final AgendaTree ifFalse;

    public BasicAgendaTreeEntry(Rule rule) {
        this(rule, null, null);
    }

    public BasicAgendaTreeEntry(Rule rule, AgendaTree ifTrue, AgendaTree ifFalse) {
        if (rule == null) {
            throw new IllegalArgumentException("rule was null");
        }
        this.rule = rule;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public void execute(ExecutionEnvironment environment) {
        boolean result = this.rule.evaluate(environment);
        if (result && this.ifTrue != null) {
            this.ifTrue.execute(environment);
        }
        if (!result && this.ifFalse != null) {
            this.ifFalse.execute(environment);
        }
    }
}

