/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine;

import org.kuali.rice.krms.api.engine.ExecutionEnvironment;

/**
 * A Rule evaluates a given {@link org.kuali.rice.krms.api.engine.ExecutionEnvironment}, returning true if its conditions pass, false if they do not.
 *
 * @see org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract
 * @see org.kuali.rice.krms.api.repository.rule.RuleDefinition
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Rule {

    /**
     * Evaluate a given {@link org.kuali.rice.krms.api.engine.ExecutionEnvironment}, returning true if the rules conditions pass, false if they do not.
     * @param environment ExecutionEnvironment
     * @return true if given {@link org.kuali.rice.krms.api.engine.ExecutionEnvironment} the rule's conditions pass, false if they do not
     */
	public boolean evaluate(ExecutionEnvironment environment);
}
