/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.type;

import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.framework.engine.Function;

/**
 * {@link FunctionTypeService} provides access and validation for custom {@link Function}s.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface FunctionTypeService {

    /**
     * Create a {@Function} from the given {@link FunctionDefinition}.
     * @param functionDefinition {@link FunctionDefinition} to create the {@link Function} from.
     * @return {@Function} created with the given {@link FunctionDefinition}
     */
	Function loadFunction(FunctionDefinition functionDefinition);
	
}
