/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.result;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ResultEvent;

public class BasicResult
extends EventObject
implements ResultEvent {
    private static final long serialVersionUID = -4124200802034785921L;
    private static final DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH.mm.ss.SSS");
    protected String type;
    protected DateTime timestamp;
    protected ExecutionEnvironment environment;
    protected Boolean result = null;
    protected String description;
    protected Map<String, ?> resultDetails;

    public BasicResult(Map<String, ?> resultDetails, String eventType, Object source, ExecutionEnvironment environment, boolean result) {
        this(resultDetails, null, eventType, source, environment, result);
    }

    public BasicResult(Map<String, ?> resultDetails, String description, String eventType, Object source, ExecutionEnvironment environment, boolean result) {
        this(eventType, source, environment);
        this.resultDetails = resultDetails;
        this.result = new Boolean(result);
        this.description = description == null ? "" : description;
    }

    public BasicResult(String description, String eventType, Object source, ExecutionEnvironment environment, boolean result) {
        this(eventType, source, environment);
        this.result = new Boolean(result);
        this.description = description;
    }

    public BasicResult(String eventType, Object source, ExecutionEnvironment environment, boolean result) {
        this(eventType, source, environment);
        this.result = new Boolean(result);
    }

    public BasicResult(String eventType, Object source, ExecutionEnvironment environment) {
        super(source);
        this.type = eventType;
        this.timestamp = new DateTime();
        this.environment = environment;
    }

    public String getType() {
        return this.type;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    public Boolean getResult() {
        return this.result;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, ?> getResultDetails() {
        if (this.resultDetails == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.resultDetails);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(fmt.print((ReadableInstant)this.getTimestamp()));
        sb.append(" EventType: " + this.getType());
        sb.append(" ( " + this.getSource().toString());
        if (this.getResult() != null) {
            sb.append(" evaluated to: " + this.getResult().toString());
        }
        sb.append(" )");
        return sb.toString();
    }
}

