/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import java.util.List;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.expression.ComparisonOperatorService;
import org.kuali.rice.krms.framework.engine.Function;
import org.kuali.rice.krms.framework.engine.expression.ComparisonOperatorServiceUtils;
import org.kuali.rice.krms.framework.engine.expression.Expression;

public final class FunctionExpression
implements Expression<Object> {
    private final Function function;
    private final String[] parameterTypes;
    private final List<Expression<? extends Object>> parameters;
    private final ComparisonOperatorService comparisonOperatorService;

    public FunctionExpression(Function function, String[] parameterTypes, List<Expression<? extends Object>> parameters, ComparisonOperatorService comparisonOperatorService) {
        this.function = function;
        this.parameterTypes = parameterTypes;
        this.parameters = parameters;
        this.comparisonOperatorService = comparisonOperatorService;
    }

    @Override
    public Object invoke(ExecutionEnvironment environment) {
        Object[] argumentValues = new Object[this.parameters.size()];
        int argValIndex = 0;
        for (Expression<? extends Object> argument : this.parameters) {
            Object argumentValue = argument.invoke(environment);
            String expectedArgumentType = this.parameterTypes[argValIndex];
            argumentValues[argValIndex] = argumentValue = ComparisonOperatorServiceUtils.coerceIfNeeded(argumentValue, expectedArgumentType, this.comparisonOperatorService);
            ++argValIndex;
        }
        return this.function.invoke(argumentValues);
    }
}

