/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.expression;

import java.util.LinkedList;
import java.util.List;
import org.kuali.rice.krms.api.engine.expression.ComparisonOperatorService;
import org.kuali.rice.krms.framework.engine.expression.DefaultComparisonOperator;
import org.kuali.rice.krms.framework.engine.expression.EngineComparatorExtension;
import org.kuali.rice.krms.framework.engine.expression.StringCoercionExtension;

public class ComparisonOperatorServiceImpl
implements ComparisonOperatorService {
    private List<EngineComparatorExtension> operators = new LinkedList<EngineComparatorExtension>();
    private List<StringCoercionExtension> stringCoercionExtensions = new LinkedList<StringCoercionExtension>();

    private ComparisonOperatorServiceImpl() {
    }

    public static ComparisonOperatorService getInstance() {
        return new ComparisonOperatorServiceImpl();
    }

    public List<StringCoercionExtension> getStringCoercionExtensions() {
        return this.stringCoercionExtensions;
    }

    public void setStringCoercionExtensions(List<StringCoercionExtension> stringCoercionExtensions) {
        this.stringCoercionExtensions = stringCoercionExtensions;
    }

    public List<EngineComparatorExtension> getOperators() {
        return this.operators;
    }

    public void setOperators(List<EngineComparatorExtension> operators) {
        this.operators = operators;
    }

    public EngineComparatorExtension findComparatorExtension(Object lhs, Object rhs) {
        for (EngineComparatorExtension extension : this.operators) {
            if (!extension.canCompare(lhs, rhs)) continue;
            return extension;
        }
        return new DefaultComparisonOperator();
    }

    public int compare(Object lhs, Object rhs) {
        return this.findComparatorExtension(lhs, rhs).compare(lhs, rhs);
    }

    public boolean canCompare(Object lhs, Object rhs) {
        return this.findComparatorExtension(lhs, rhs) != null;
    }

    public StringCoercionExtension findStringCoercionExtension(String type, String value) {
        for (StringCoercionExtension extension : this.stringCoercionExtensions) {
            if (!extension.canCoerce(type, value)) continue;
            return extension;
        }
        return new DefaultComparisonOperator();
    }

    public boolean canCoerce(String type, String value) {
        return this.findStringCoercionExtension(type, value) != null;
    }

    public Object coerce(String type, String value) {
        return this.findStringCoercionExtension(type, value).coerce(type, value);
    }
}

