/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.action.ActionDefinitionContract;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.ActionBoService;

public final class ActionBoServiceImpl
implements ActionBoService {
    private BusinessObjectService businessObjectService;

    @Override
    public ActionDefinition createAction(ActionDefinition action) {
        String actionNamespaceKey;
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        String actionNameKey = action.getName();
        ActionDefinition existing = this.getActionByNameAndNamespace(actionNameKey, actionNamespaceKey = action.getNamespace());
        if (existing != null) {
            throw new IllegalStateException("the action to create already exists: " + action);
        }
        ActionBo bo = ActionBo.from(action);
        this.businessObjectService.save((PersistableBusinessObject)bo);
        return ActionBo.to(bo);
    }

    @Override
    public void updateAction(ActionDefinition action) {
        ActionDefinition toUpdate;
        if (action == null) {
            throw new IllegalArgumentException("action is null");
        }
        String actionIdKey = action.getId();
        ActionBo existing = (ActionBo)this.businessObjectService.findBySinglePrimaryKey(ActionBo.class, (Object)actionIdKey);
        if (existing == null) {
            throw new IllegalStateException("the action does not exist: " + action);
        }
        if (existing.getId().equals(action.getId())) {
            toUpdate = action;
        } else {
            ActionDefinition.Builder builder = ActionDefinition.Builder.create((ActionDefinitionContract)action);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        }
        ActionBo boToUpdate = ActionBo.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("actionId", toUpdate.getId());
        this.businessObjectService.deleteMatching(ActionAttributeBo.class, fields);
        this.businessObjectService.save((PersistableBusinessObject)boToUpdate);
    }

    @Override
    public ActionDefinition getActionByActionId(String actionId) {
        if (StringUtils.isBlank((String)actionId)) {
            throw new IllegalArgumentException("action ID is null or blank");
        }
        ActionBo bo = (ActionBo)this.businessObjectService.findBySinglePrimaryKey(ActionBo.class, (Object)actionId);
        return ActionBo.to(bo);
    }

    @Override
    public ActionDefinition getActionByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        ActionBo myAction = (ActionBo)this.businessObjectService.findByPrimaryKey(ActionBo.class, Collections.unmodifiableMap(map));
        return ActionBo.to(myAction);
    }

    @Override
    public List<ActionDefinition> getActionsByRuleId(String ruleId) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("ruleId is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ruleId", ruleId);
        List bos = (List)this.businessObjectService.findMatchingOrderBy(ActionBo.class, map, "sequenceNumber", true);
        return this.convertListOfBosToImmutables(bos);
    }

    @Override
    public ActionDefinition getActionByRuleIdAndSequenceNumber(String ruleId, Integer sequenceNumber) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("ruleId is null or blank");
        }
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("sequenceNumber is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleId", ruleId);
        map.put("sequenceNumber", sequenceNumber);
        ActionBo bo = (ActionBo)this.businessObjectService.findByPrimaryKey(ActionBo.class, map);
        return ActionBo.to(bo);
    }

    public ActionAttributeBo getActionAttributeById(String attrId) {
        if (StringUtils.isBlank((String)attrId)) {
            return null;
        }
        return (ActionAttributeBo)this.businessObjectService.findBySinglePrimaryKey(ActionAttributeBo.class, (Object)attrId);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    List<ActionDefinition> convertListOfBosToImmutables(Collection<ActionBo> actionBos) {
        if (actionBos == null) {
            return Collections.emptyList();
        }
        ArrayList<ActionDefinition> actions = new ArrayList<ActionDefinition>();
        for (ActionBo bo : actionBos) {
            ActionDefinition action = ActionBo.to(bo);
            actions.add(action);
        }
        return Collections.unmodifiableList(actions);
    }
}

