/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.DataType;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.core.api.util.tree.Tree;
import org.kuali.rice.core.impl.cache.DistributedCacheManagerDecorator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.uif.container.CollectionGroup;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.api.repository.function.FunctionDefinition;
import org.kuali.rice.krms.api.repository.operator.CustomOperator;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionParameterBo;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermParameterBo;
import org.kuali.rice.krms.impl.ui.AgendaEditor;
import org.kuali.rice.krms.impl.ui.RuleTreeNode;
import org.kuali.rice.krms.impl.util.KrmsRetriever;
import org.kuali.rice.krms.impl.util.KrmsServiceLocatorInternal;

public class AgendaEditorMaintainable
extends MaintainableImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(AgendaEditorMaintainable.class);
    public static final String NEW_AGENDA_EDITOR_DOCUMENT_TEXT = "New Agenda Editor Document";
    private transient SequenceAccessorService sequenceAccessorService;
    private transient KrmsRetriever krmsRetriever = new KrmsRetriever();

    public BusinessObjectService getBoService() {
        return KRADServiceLocator.getBusinessObjectService();
    }

    private ContextBoService getContextBoService() {
        return KrmsRepositoryServiceLocator.getContextBoService();
    }

    public List<RemotableAttributeField> retrieveAgendaCustomAttributes(View view, Object model, Container container) {
        AgendaEditor agendaEditor = this.getAgendaEditor(model);
        return this.krmsRetriever.retrieveAgendaCustomAttributes(agendaEditor);
    }

    public List<RemotableAttributeField> retrieveTermParameters(View view, Object model, Container container) {
        String termSpecId;
        TermResolverDefinition simplestResolver;
        PropositionParameterBo param;
        PropositionBo propositionBo;
        Tree propositionTree;
        Node<RuleTreeNode, String> editedPropositionNode;
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        AgendaEditor agendaEditor = this.getAgendaEditor(model);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        if (null != rule && (editedPropositionNode = this.findEditedProposition((Node<RuleTreeNode, String>)(propositionTree = rule.getPropositionTree()).getRootElement())) != null && StringUtils.isEmpty((String)(propositionBo = ((RuleTreeNode)editedPropositionNode.getData()).getProposition()).getCompoundOpCode()) && CollectionUtils.size(propositionBo.getParameters()) > 0 && (param = propositionBo.getParameters().get(0)).getValue().startsWith("parameterized:") && (simplestResolver = AgendaEditorMaintainable.getSimplestTermResolver(termSpecId = param.getValue().substring("parameterized:".length()), rule.getNamespace())) != null) {
            ArrayList parameterNames = new ArrayList(simplestResolver.getParameterNames());
            Collections.sort(parameterNames);
            for (String parameterName : parameterNames) {
                RemotableTextInput.Builder controlBuilder = RemotableTextInput.Builder.create();
                controlBuilder.setSize(Integer.valueOf(64));
                RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)parameterName);
                builder.setRequired(true);
                builder.setDataType(DataType.STRING);
                builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
                builder.setLongLabel(parameterName);
                builder.setShortLabel(parameterName);
                builder.setMinLength(Integer.valueOf(1));
                builder.setMaxLength(Integer.valueOf(64));
                results.add(builder.build());
            }
        }
        return results;
    }

    static TermResolverDefinition getSimplestTermResolver(String termSpecId, String namespace) {
        List resolvers = KrmsRepositoryServiceLocator.getTermBoService().findTermResolversByOutputId(termSpecId, namespace);
        TermResolverDefinition simplestResolver = null;
        for (TermResolverDefinition resolver : resolvers) {
            if (simplestResolver != null && simplestResolver.getParameterNames().size() >= resolver.getParameterNames().size()) continue;
            simplestResolver = resolver;
        }
        return simplestResolver;
    }

    private Node<RuleTreeNode, String> findEditedProposition(Node<RuleTreeNode, String> node) {
        Node<RuleTreeNode, String> result = null;
        if (node.getData() != null && ((RuleTreeNode)node.getData()).getProposition() != null && ((RuleTreeNode)node.getData()).getProposition().getEditMode()) {
            result = node;
        } else {
            Node child;
            Iterator i$ = node.getChildren().iterator();
            while (i$.hasNext() && (result = this.findEditedProposition((Node<RuleTreeNode, String>)(child = (Node)i$.next()))) == null) {
            }
        }
        return result;
    }

    private AgendaEditor getAgendaEditor(Object model) {
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
        return (AgendaEditor)((Object)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject());
    }

    public List<RemotableAttributeField> retrieveRuleActionCustomAttributes(View view, Object model, Container container) {
        AgendaEditor agendaEditor = this.getAgendaEditor((MaintenanceDocumentForm)model);
        return this.krmsRetriever.retrieveRuleActionCustomAttributes(agendaEditor);
    }

    public List<RemotableAttributeField> retrieveRuleCustomAttributes(View view, Object model, Container container) {
        AgendaEditor agendaEditor = this.getAgendaEditor((MaintenanceDocumentForm)model);
        return this.krmsRetriever.retrieveRuleCustomAttributes(agendaEditor);
    }

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        AgendaEditor dataObject;
        block4: {
            dataObject = null;
            try {
                AgendaEditor agendaEditor = new AgendaEditor();
                AgendaBo agenda = (AgendaBo)((Object)this.getLookupService().findObjectBySearch(((Object)((Object)((AgendaEditor)((Object)this.getDataObject())).getAgenda())).getClass(), dataObjectKeys));
                if ("Copy".equals(this.getMaintenanceAction())) {
                    String dateTimeStamp = new Date().getTime() + "";
                    String newAgendaName = "Copy of " + agenda.getName() + " " + dateTimeStamp;
                    AgendaBo copiedAgenda = agenda.copyAgenda(newAgendaName, dateTimeStamp);
                    document.getDocumentHeader().setDocumentDescription(NEW_AGENDA_EDITOR_DOCUMENT_TEXT);
                    document.setFieldsClearedOnCopy(true);
                    agendaEditor.setAgenda(copiedAgenda);
                } else {
                    agendaEditor.setAgenda(agenda);
                }
                agendaEditor.setCustomAttributesMap(agenda.getAttributes());
                agendaEditor.setNamespace(agenda.getContext().getNamespace());
                agendaEditor.setContextName(agenda.getContext().getName());
                dataObject = agendaEditor;
            }
            catch (ClassNotPersistenceCapableException ex) {
                if (document.getOldMaintainableObject().isExternalBusinessObject()) break block4;
                throw new RuntimeException("Data Object Class: " + this.getDataObjectClass() + " is not persistable and is not externalizable - configuration error");
            }
        }
        return dataObject;
    }

    private SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KRADServiceLocator.getSequenceAccessorService();
        }
        return this.sequenceAccessorService;
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterNew(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription(NEW_AGENDA_EDITOR_DOCUMENT_TEXT);
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterEdit(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("Modify Agenda Editor Document");
    }

    public void prepareForSave() {
        AgendaEditor agendaEditor = (AgendaEditor)((Object)this.getDataObject());
        agendaEditor.getAgenda().setAttributes(agendaEditor.getCustomAttributesMap());
    }

    public void saveDataObject() {
        AgendaBo agendaBo = ((AgendaEditor)((Object)this.getDataObject())).getAgenda();
        for (AgendaItemBo agendaItem : agendaBo.getItems()) {
            PropositionBo propositionBo = agendaItem.getRule().getProposition();
            if (propositionBo == null) continue;
            this.saveNewParameterizedTerms(propositionBo);
            this.processCustomOperators(propositionBo);
        }
        if (agendaBo instanceof PersistableBusinessObject) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("id", agendaBo.getId());
            AgendaBo dbAgendaBo = (AgendaBo)this.getBusinessObjectService().findByPrimaryKey(AgendaBo.class, primaryKeys);
            if (ObjectUtils.isNotNull((Object)((Object)dbAgendaBo))) {
                HashMap<String, String> primaryKeyForFirstItem = new HashMap<String, String>();
                primaryKeyForFirstItem.put("id", dbAgendaBo.getFirstItemId());
                AgendaItemBo dbFirstAgendaItemBo = (AgendaItemBo)this.getBusinessObjectService().findByPrimaryKey(AgendaItemBo.class, primaryKeyForFirstItem);
                ArrayList<AgendaItemBo> deletionOrder = new ArrayList<AgendaItemBo>();
                this.addItemsToListForDeletion(deletionOrder, dbFirstAgendaItemBo);
                for (AgendaItemBo agendaItemToDelete : deletionOrder) {
                    this.getBusinessObjectService().delete((PersistableBusinessObject)agendaItemToDelete);
                }
                dbAgendaBo.setItems(null);
                this.getBusinessObjectService().delete((PersistableBusinessObject)dbAgendaBo);
            }
        } else {
            throw new RuntimeException("Cannot save object of type: " + (Object)((Object)agendaBo) + " with business object service");
        }
        this.flushCacheBeforeSave();
        this.getBusinessObjectService().linkAndSave((PersistableBusinessObject)agendaBo);
    }

    private void addItemsToListForDeletion(List<AgendaItemBo> deletionOrder, AgendaItemBo agendaItemBo) {
        if (!deletionOrder.contains((Object)agendaItemBo) && ObjectUtils.isNotNull((Object)((Object)agendaItemBo))) {
            deletionOrder.add(agendaItemBo);
        }
        if (ObjectUtils.isNotNull((Object)((Object)agendaItemBo))) {
            if (StringUtils.isNotBlank((String)agendaItemBo.getWhenTrueId()) && !deletionOrder.contains((Object)agendaItemBo.getWhenTrue())) {
                deletionOrder.add(agendaItemBo.getWhenTrue());
                this.addItemsToListForDeletion(deletionOrder, agendaItemBo.getWhenTrue());
            }
            if (StringUtils.isNotBlank((String)agendaItemBo.getWhenFalseId()) && !deletionOrder.contains((Object)agendaItemBo.getWhenFalse())) {
                deletionOrder.add(agendaItemBo.getWhenFalse());
                this.addItemsToListForDeletion(deletionOrder, agendaItemBo.getWhenFalse());
            }
            if (StringUtils.isNotBlank((String)agendaItemBo.getAlwaysId()) && !deletionOrder.contains((Object)agendaItemBo.getAlways())) {
                deletionOrder.add(agendaItemBo.getAlways());
                this.addItemsToListForDeletion(deletionOrder, agendaItemBo.getAlways());
            }
        }
    }

    private void flushCacheBeforeSave() {
        DistributedCacheManagerDecorator distributedCacheManagerDecorator = (DistributedCacheManagerDecorator)GlobalResourceLoader.getService((String)"krmsDistributedCacheManager");
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/ActionType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/AgendaItemType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/AgendaTreeDefinition").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/AgendaType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/ContextDefinitionType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/KrmsAttributionDefinitionType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/KRMSTypeType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/RuleType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/PropositionType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/RuleType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/termDefinitionType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/termResolverDefinitionType").clear();
        distributedCacheManagerDecorator.getCache("http://rice.kuali.org/krms/v2_0/TermSpecificationType").clear();
    }

    private void saveNewParameterizedTerms(PropositionBo propositionBo) {
        if (StringUtils.isBlank((String)propositionBo.getCompoundOpCode())) {
            if (!propositionBo.getParameters().isEmpty() && propositionBo.getParameters().get(0).getValue().startsWith("parameterized:")) {
                String termId = propositionBo.getParameters().get(0).getValue();
                String termSpecId = termId.substring("parameterized:".length());
                TermBo newTerm = new TermBo();
                newTerm.setDescription(propositionBo.getNewTermDescription());
                newTerm.setSpecificationId(termSpecId);
                newTerm.setId(KRADServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber("KRMS_TERM_S", TermBo.class).toString());
                ArrayList<TermParameterBo> params = new ArrayList<TermParameterBo>();
                for (Map.Entry<String, String> entry : propositionBo.getTermParameters().entrySet()) {
                    TermParameterBo param = new TermParameterBo();
                    param.setTermId(newTerm.getId());
                    param.setName(entry.getKey());
                    param.setValue(entry.getValue());
                    param.setId(KRADServiceLocator.getSequenceAccessorService().getNextAvailableSequenceNumber("KRMS_TERM_PARM_S", TermParameterBo.class).toString());
                    params.add(param);
                }
                newTerm.setParameters(params);
                KRADServiceLocator.getBusinessObjectService().linkAndSave((PersistableBusinessObject)newTerm);
                propositionBo.getParameters().get(0).setValue(newTerm.getId());
            }
        } else {
            for (PropositionBo childProp : propositionBo.getCompoundComponents()) {
                this.saveNewParameterizedTerms(childProp);
            }
        }
    }

    private void processCustomOperators(PropositionBo propositionBo) {
        if (StringUtils.isBlank((String)propositionBo.getCompoundOpCode())) {
            if (!propositionBo.getParameters().isEmpty() && propositionBo.getParameters().get(2).getValue().startsWith("customOperator:")) {
                PropositionParameterBo operatorParam = propositionBo.getParameters().get(2);
                CustomOperator customOperator = KrmsServiceLocatorInternal.getCustomOperatorUiTranslator().getCustomOperator(operatorParam.getValue());
                FunctionDefinition operatorFunctionDefinition = customOperator.getOperatorFunctionDefinition();
                operatorParam.setParameterType(PropositionParameterType.FUNCTION.getCode());
                operatorParam.setValue(operatorFunctionDefinition.getId());
            }
        } else {
            for (PropositionBo childProp : propositionBo.getCompoundComponents()) {
                this.processCustomOperators(childProp);
            }
        }
    }

    private Map<String, KrmsAttributeDefinition> buildAttributeDefinitionMap(String agendaTypeId) {
        KrmsAttributeDefinitionService attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = attributeDefinitionService.findAttributeDefinitionsByType(agendaTypeId);
        for (KrmsAttributeDefinition attributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(attributeDefinition.getName(), attributeDefinition);
        }
        return attributeDefinitionMap;
    }

    public boolean isOldDataObjectInDocument() {
        boolean isOldDataObjectInExistence = true;
        if (this.getDataObject() == null) {
            isOldDataObjectInExistence = false;
        } else {
            Map keyFieldValues = this.getDataObjectMetaDataService().getPrimaryKeyFieldValues((Object)((AgendaEditor)((Object)this.getDataObject())).getAgenda());
            for (Object keyValue : keyFieldValues.values()) {
                if (keyValue == null) {
                    isOldDataObjectInExistence = false;
                } else if (keyValue instanceof String && StringUtils.isBlank((String)((String)keyValue))) {
                    isOldDataObjectInExistence = false;
                }
                if (isOldDataObjectInExistence) continue;
                break;
            }
        }
        return isOldDataObjectInExistence;
    }

    public Class getDataObjectClass() {
        return AgendaBo.class;
    }

    public boolean isLockable() {
        return true;
    }

    public PersistableBusinessObject getPersistableBusinessObject() {
        return ((AgendaEditor)((Object)this.getDataObject())).getAgenda();
    }

    protected void processBeforeAddLine(View view, CollectionGroup collectionGroup, Object model, Object addLine) {
        AgendaEditor agendaEditor = this.getAgendaEditor(model);
        if (addLine instanceof ActionBo) {
            ((ActionBo)((Object)addLine)).setNamespace(agendaEditor.getAgendaItemLine().getRule().getNamespace());
        }
        super.processBeforeAddLine(view, collectionGroup, model, addLine);
    }
}

