/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;

public class TermSpecificationMaintainable
extends MaintainableImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(TermSpecificationMaintainable.class);

    public BusinessObjectService getBoService() {
        return KRADServiceLocator.getBusinessObjectService();
    }

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        TermSpecificationBo termSpecificationBo = (TermSpecificationBo)((Object)super.retrieveObjectForEditOrCopy(document, dataObjectKeys));
        if (!CollectionUtils.isEmpty(termSpecificationBo.getContextIds())) {
            for (String contextId : termSpecificationBo.getContextIds()) {
                ContextDefinition context = KrmsRepositoryServiceLocator.getContextBoService().getContextByContextId(contextId);
                if (context == null) continue;
                termSpecificationBo.getContexts().add(ContextBo.from(context));
            }
        }
        if ("Copy".equals(this.getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Term Specification Document");
        }
        return termSpecificationBo;
    }

    private void findContexts(TermSpecificationBo termSpecificationBo) {
        Collection validContextMappings = this.getBoService().findMatching(ContextValidTermBo.class, Collections.singletonMap("termSpecificationId", termSpecificationBo.getId()));
        if (!CollectionUtils.isEmpty((Collection)validContextMappings)) {
            for (ContextValidTermBo validContextMapping : validContextMappings) {
                termSpecificationBo.getContextIds().add(validContextMapping.getContextId());
            }
        }
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterNew(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("New Term Specification Document");
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterEdit(document, requestParameters);
        this.copyContextsOldToNewBo(document);
        document.getDocumentHeader().setDocumentDescription("Edited Term Specification Document");
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterCopy(document, requestParameters);
        this.copyContextsOldToNewBo(document);
    }

    private void copyContextsOldToNewBo(MaintenanceDocument document) {
        TermSpecificationBo oldTermSpec = (TermSpecificationBo)((Object)document.getOldMaintainableObject().getDataObject());
        TermSpecificationBo newTermSpec = (TermSpecificationBo)((Object)document.getNewMaintainableObject().getDataObject());
        newTermSpec.setContexts(new ArrayList<ContextBo>());
        for (ContextBo contextBo : oldTermSpec.getContexts()) {
            newTermSpec.getContexts().add(contextBo);
        }
    }

    public void prepareForSave() {
        super.prepareForSave();
        TermSpecificationBo termSpec = (TermSpecificationBo)((Object)this.getDataObject());
        termSpec.setContextIds(new ArrayList<String>());
        for (ContextBo context : termSpec.getContexts()) {
            termSpec.getContextIds().add(context.getId());
        }
    }

    public void saveDataObject() {
        TermSpecificationBo termSpec = (TermSpecificationBo)((Object)this.getDataObject());
        super.saveDataObject();
        if (termSpec.getId() != null) {
            this.getBoService().deleteMatching(ContextValidTermBo.class, Collections.singletonMap("termSpecificationId", termSpec.getId()));
            for (String contextId : termSpec.getContextIds()) {
                ContextValidTermBo contextValidTerm = new ContextValidTermBo();
                contextValidTerm.setContextId(contextId);
                contextValidTerm.setTermSpecificationId(termSpec.getId());
                this.getBoService().save((PersistableBusinessObject)contextValidTerm);
            }
        }
    }

    public Class getDataObjectClass() {
        return TermSpecificationBo.class;
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        TermSpecificationBo termSpec = (TermSpecificationBo)((Object)this.getDataObject());
        termSpec.setContexts(new ArrayList<ContextBo>());
        for (String contextId : termSpec.getContextIds()) {
            ContextDefinition context = KrmsRepositoryServiceLocator.getContextBoService().getContextByContextId(contextId);
            termSpec.getContexts().add(ContextBo.from(context));
        }
    }
}

