/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.impl.repository.CategoryBo;
import org.kuali.rice.krms.impl.repository.ContextValidTermBo;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermResolverBo;
import org.kuali.rice.krms.impl.repository.TermSpecificationBo;
import org.kuali.rice.krms.impl.ui.AgendaEditor;

public class ValidTermsValuesFinder
extends UifKeyValuesFinderBase {
    public List<KeyValue> getKeyValues(ViewModel model) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)model;
        AgendaEditor agendaEditor = (AgendaEditor)((Object)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject());
        String contextId = agendaEditor.getAgenda().getContextId();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        PropositionBo rootProposition = agendaEditor.getAgendaItemLine().getRule().getProposition();
        PropositionBo editModeProposition = this.findPropositionUnderEdit(rootProposition);
        String selectedCategoryId = editModeProposition != null ? editModeProposition.getCategoryId() : null;
        Collection contextValidTerms = null;
        contextValidTerms = KRADServiceLocator.getBusinessObjectService().findMatching(ContextValidTermBo.class, Collections.singletonMap("contextId", contextId));
        ArrayList<String> termSpecIds = new ArrayList<String>();
        for (ContextValidTermBo validTerm : contextValidTerms) {
            termSpecIds.add(validTerm.getTermSpecificationId());
        }
        if (termSpecIds.size() > 0) {
            Collection terms = null;
            HashMap<String, ArrayList<String>> criteria = new HashMap<String, ArrayList<String>>();
            criteria.put("specificationId", termSpecIds);
            terms = KRADServiceLocator.getBusinessObjectService().findMatchingOrderBy(TermBo.class, criteria, "description", true);
            for (TermBo term : terms) {
                String selectName = term.getDescription();
                if (StringUtils.isBlank((String)selectName) || "null".equals(selectName)) {
                    selectName = term.getSpecification().getName();
                }
                if (!StringUtils.isBlank((String)selectedCategoryId)) {
                    if (!this.isTermSpecificationInCategory(term.getSpecification(), selectedCategoryId)) continue;
                    keyValues.add((KeyValue)new ConcreteKeyValue(term.getId(), selectName));
                    continue;
                }
                keyValues.add((KeyValue)new ConcreteKeyValue(term.getId(), selectName));
            }
            Collection termResolvers = KRADServiceLocator.getBusinessObjectService().findMatchingOrderBy(TermResolverBo.class, Collections.singletonMap("outputId", termSpecIds), "name", true);
            if (termResolvers != null) {
                for (TermResolverBo termResolver : termResolvers) {
                    if (CollectionUtils.isEmpty(termResolver.getParameterSpecifications())) continue;
                    TermSpecificationBo output = termResolver.getOutput();
                    if (!StringUtils.isBlank((String)selectedCategoryId) && !this.isTermSpecificationInCategory(output, selectedCategoryId)) continue;
                    String outputDescription = StringUtils.isBlank((String)output.getDescription()) ? output.getName() : output.getDescription();
                    keyValues.add((KeyValue)new ConcreteKeyValue("parameterized:" + output.getId(), outputDescription + "(" + StringUtils.repeat((String)"_", (String)",", (int)termResolver.getParameterSpecifications().size()) + ")"));
                }
            }
        }
        return keyValues;
    }

    private boolean isTermSpecificationInCategory(TermSpecificationBo termSpec, String categoryId) {
        if (termSpec.getCategories() != null) {
            for (CategoryBo category : termSpec.getCategories()) {
                if (!categoryId.equals(category.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private PropositionBo findPropositionUnderEdit(PropositionBo currentProposition) {
        PropositionBo result;
        block2: {
            PropositionBo child;
            block1: {
                result = null;
                if (!currentProposition.getEditMode()) break block1;
                result = currentProposition;
                break block2;
            }
            if (currentProposition.getCompoundComponents() == null) break block2;
            Iterator<PropositionBo> i$ = currentProposition.getCompoundComponents().iterator();
            while (i$.hasNext() && (result = this.findPropositionUnderEdit(child = i$.next())) == null) {
            }
        }
        return result;
    }
}

