/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelation;
import org.kuali.rice.krms.api.repository.typerelation.TypeTypeRelationContract;
import org.kuali.rice.krms.impl.repository.TypeTypeRelationSequenceComparator;

public class KrmsTypeRepositoryServiceMockImpl
implements KrmsTypeRepositoryService {
    private Map<String, KrmsTypeDefinition> krmsTypeMap = new LinkedHashMap<String, KrmsTypeDefinition>();
    private Map<String, KrmsAttributeDefinition> krmsAttributeDefinitionMap = new LinkedHashMap<String, KrmsAttributeDefinition>();
    private Map<String, TypeTypeRelation> typeTypeRelationMap = new LinkedHashMap<String, TypeTypeRelation>();

    public void clear() {
        this.krmsTypeMap.clear();
        this.krmsAttributeDefinitionMap.clear();
        this.typeTypeRelationMap.clear();
    }

    public KrmsTypeDefinition createKrmsType(KrmsTypeDefinition krmsType) throws RiceIllegalArgumentException, RiceIllegalStateException {
        KrmsTypeDefinition orig = this.getTypeByName(krmsType.getNamespace(), krmsType.getName());
        if (orig != null) {
            throw new RiceIllegalArgumentException(krmsType.getNamespace() + "." + krmsType.getName() + " already exists");
        }
        KrmsTypeDefinition.Builder copy = KrmsTypeDefinition.Builder.create((KrmsTypeDefinitionContract)krmsType);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        krmsType = copy.build();
        this.krmsTypeMap.put(krmsType.getId(), krmsType);
        return krmsType;
    }

    public KrmsTypeDefinition updateKrmsType(KrmsTypeDefinition krmsType) throws RiceIllegalArgumentException, RiceIllegalStateException {
        KrmsTypeDefinition.Builder copy = KrmsTypeDefinition.Builder.create((KrmsTypeDefinitionContract)krmsType);
        KrmsTypeDefinition old = this.getTypeById(krmsType.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        krmsType = copy.build();
        this.krmsTypeMap.put(krmsType.getId(), krmsType);
        return krmsType;
    }

    public KrmsTypeDefinition getTypeById(String id) throws RiceIllegalArgumentException {
        if (!this.krmsTypeMap.containsKey(id)) {
            throw new RiceIllegalArgumentException(id);
        }
        return this.krmsTypeMap.get(id);
    }

    public KrmsTypeDefinition getTypeByName(String namespaceCode, String name) throws RiceIllegalArgumentException, RiceIllegalStateException {
        for (KrmsTypeDefinition type : this.krmsTypeMap.values()) {
            if (!type.getName().equals(name) || !type.getNamespace().equals(namespaceCode)) continue;
            return type;
        }
        return null;
    }

    public List<KrmsTypeDefinition> findAllTypesByNamespace(String namespaceCode) throws RiceIllegalArgumentException {
        ArrayList<KrmsTypeDefinition> list = new ArrayList<KrmsTypeDefinition>();
        for (KrmsTypeDefinition type : this.krmsTypeMap.values()) {
            if (!type.getNamespace().equals(namespaceCode)) continue;
            list.add(type);
        }
        return list;
    }

    public List<KrmsTypeDefinition> findAllTypes() {
        return new ArrayList<KrmsTypeDefinition>(this.krmsTypeMap.values());
    }

    public KrmsTypeDefinition getAgendaTypeByAgendaTypeIdAndContextId(String agendaTypeId, String contextId) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("getAgendaTypeByAgendaTypeIdAndContextId is being deprecated");
    }

    public List<KrmsTypeDefinition> findAllAgendaTypesByContextId(String contextId) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("findAllAgendaTypesByContextId is being deprecated");
    }

    public List<KrmsTypeDefinition> findAllRuleTypesByContextId(String contextId) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("findAllRuleTypesByContextId is being deprecated");
    }

    public KrmsTypeDefinition getRuleTypeByRuleTypeIdAndContextId(String ruleTypeId, String contextId) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("getRuleTypeByRuleTypeIdAndContextId is being deprecated");
    }

    public List<KrmsTypeDefinition> findAllActionTypesByContextId(String contextId) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("findAllActionTypesByContextId is being deprecated");
    }

    public KrmsTypeDefinition getActionTypeByActionTypeIdAndContextId(String actionTypeId, String contextId) throws RiceIllegalArgumentException {
        throw new RiceIllegalArgumentException("getActionTypeByActionTypeIdAndContextId is being deprecated");
    }

    public KrmsAttributeDefinition getAttributeDefinitionById(String attributeDefinitionId) throws RiceIllegalArgumentException {
        if (!this.krmsAttributeDefinitionMap.containsKey(attributeDefinitionId)) {
            throw new RiceIllegalArgumentException(attributeDefinitionId);
        }
        return this.krmsAttributeDefinitionMap.get(attributeDefinitionId);
    }

    public KrmsAttributeDefinition getAttributeDefinitionByName(String namespaceCode, String name) throws RiceIllegalArgumentException {
        for (KrmsAttributeDefinition info : this.krmsAttributeDefinitionMap.values()) {
            if (!info.getNamespace().equals(namespaceCode) || !info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public TypeTypeRelation createTypeTypeRelation(TypeTypeRelation typeTypeRelation) throws RiceIllegalArgumentException {
        try {
            TypeTypeRelation orig = this.getTypeTypeRelation(typeTypeRelation.getId());
            if (orig != null) {
                throw new RiceIllegalArgumentException(typeTypeRelation.getId() + " already exists");
            }
        }
        catch (RiceIllegalArgumentException orig) {
            // empty catch block
        }
        TypeTypeRelation.Builder copy = TypeTypeRelation.Builder.create((TypeTypeRelationContract)typeTypeRelation);
        if (copy.getId() == null) {
            copy.setId(UUID.randomUUID().toString());
        }
        typeTypeRelation = copy.build();
        this.typeTypeRelationMap.put(typeTypeRelation.getId(), typeTypeRelation);
        return typeTypeRelation;
    }

    public TypeTypeRelation getTypeTypeRelation(String typeTypeRelationId) throws RiceIllegalArgumentException {
        if (!this.typeTypeRelationMap.containsKey(typeTypeRelationId)) {
            throw new RiceIllegalArgumentException(typeTypeRelationId);
        }
        return this.typeTypeRelationMap.get(typeTypeRelationId);
    }

    public void updateTypeTypeRelation(TypeTypeRelation typeTypeRelation) throws RiceIllegalArgumentException {
        TypeTypeRelation.Builder copy = TypeTypeRelation.Builder.create((TypeTypeRelationContract)typeTypeRelation);
        TypeTypeRelation old = this.getTypeTypeRelation(typeTypeRelation.getId());
        if (!old.getVersionNumber().equals(copy.getVersionNumber())) {
            throw new RiceIllegalStateException("" + old.getVersionNumber());
        }
        copy.setVersionNumber(Long.valueOf(copy.getVersionNumber() + 1L));
        typeTypeRelation = copy.build();
        this.typeTypeRelationMap.put(typeTypeRelation.getId(), typeTypeRelation);
    }

    public void deleteTypeTypeRelation(String typeTypeRelationId) throws RiceIllegalArgumentException {
        if (this.typeTypeRelationMap.remove(typeTypeRelationId) == null) {
            throw new RiceIllegalArgumentException(typeTypeRelationId);
        }
    }

    public List<TypeTypeRelation> findTypeTypeRelationsByFromType(String fromTypeId) throws RiceIllegalArgumentException {
        ArrayList<TypeTypeRelation> list = new ArrayList<TypeTypeRelation>();
        for (TypeTypeRelation rel : this.typeTypeRelationMap.values()) {
            if (!rel.getFromTypeId().equals(fromTypeId)) continue;
            list.add(rel);
        }
        return list;
    }

    public List<TypeTypeRelation> findTypeTypeRelationsByToType(String toTypeId) throws RiceIllegalArgumentException {
        ArrayList<TypeTypeRelation> list = new ArrayList<TypeTypeRelation>();
        for (TypeTypeRelation rel : this.typeTypeRelationMap.values()) {
            if (!rel.getToTypeId().equals(toTypeId)) continue;
            list.add(rel);
        }
        return list;
    }

    public List<TypeTypeRelation> findTypeTypeRelationsByRelationshipType(RelationshipType relationshipType) throws RiceIllegalArgumentException {
        ArrayList<TypeTypeRelation> list = new ArrayList<TypeTypeRelation>();
        for (TypeTypeRelation rel : this.typeTypeRelationMap.values()) {
            if (!rel.getRelationshipType().equals((Object)relationshipType)) continue;
            list.add(rel);
        }
        return list;
    }

    public List<KrmsTypeDefinition> findAllTypesByServiceName(String serviceName) throws RiceIllegalArgumentException {
        return this._findAllTypesByServiceNames(Arrays.asList(serviceName));
    }

    private List<KrmsTypeDefinition> _findAllTypesByServiceNames(List<String> serviceNames) throws RiceIllegalArgumentException {
        ArrayList<KrmsTypeDefinition> list = new ArrayList<KrmsTypeDefinition>();
        for (KrmsTypeDefinition info : this.krmsTypeMap.values()) {
            if (!serviceNames.contains(info.getServiceName())) continue;
            list.add(info);
        }
        return list;
    }

    public List<KrmsTypeDefinition> findAllContextTypes() throws RiceIllegalArgumentException {
        return this.findAllTypesByServiceName("contextTypeService");
    }

    public List<KrmsTypeDefinition> findAllAgendaTypes() throws RiceIllegalArgumentException {
        return this.findAllTypesByServiceName("agendaTypeService");
    }

    public List<KrmsTypeDefinition> findAllRuleTypes() throws RiceIllegalArgumentException {
        return this.findAllTypesByServiceName("ruleTypeService");
    }

    public List<KrmsTypeDefinition> findAllPropositionTypes() throws RiceIllegalArgumentException {
        return this._findAllTypesByServiceNames(Arrays.asList(PROPOSITION_SERVICE_NAMES));
    }

    public List<KrmsTypeDefinition> findAllPropositionParameterTypes() throws RiceIllegalArgumentException {
        return this._findAllTypesByServiceNames(Arrays.asList(PROPOSITION_PARAMETER_SERVICE_NAMES));
    }

    public List<KrmsTypeDefinition> findAgendaTypesForContextType(String contextTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(contextTypeId, Arrays.asList("contextTypeService"), Arrays.asList("agendaTypeService"));
    }

    private List<KrmsTypeDefinition> _findTypesForType(String typeId, List<String> fromServiceNames, List<String> toServiceNames) throws RiceIllegalArgumentException {
        KrmsTypeDefinition fromType = this.getTypeById(typeId);
        if (fromType == null) {
            throw new RiceIllegalArgumentException(typeId + " does not exist");
        }
        if (!fromServiceNames.contains(fromType.getServiceName())) {
            throw new RiceIllegalArgumentException(typeId + "'s serviceTypeName is " + fromType.getServiceName() + " expected " + fromServiceNames);
        }
        List<TypeTypeRelation> rels = this.findTypeTypeRelationsByFromType(typeId);
        Collections.sort(rels, new TypeTypeRelationSequenceComparator());
        ArrayList<KrmsTypeDefinition> list = new ArrayList<KrmsTypeDefinition>(rels.size());
        for (TypeTypeRelation rel : rels) {
            KrmsTypeDefinition info = this.getTypeById(rel.getToTypeId());
            if (!toServiceNames.contains(info.getServiceName())) continue;
            list.add(info);
        }
        return list;
    }

    public List<KrmsTypeDefinition> findAgendaTypesForAgendaType(String agendaTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(agendaTypeId, Arrays.asList("agendaTypeService"), Arrays.asList("agendaTypeService"));
    }

    public List<KrmsTypeDefinition> findRuleTypesForAgendaType(String agendaTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(agendaTypeId, Arrays.asList("agendaTypeService"), Arrays.asList("ruleTypeService"));
    }

    public List<KrmsTypeDefinition> findPropositionTypesForRuleType(String ruleTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(ruleTypeId, Arrays.asList("ruleTypeService"), Arrays.asList(PROPOSITION_SERVICE_NAMES));
    }

    public List<KrmsTypeDefinition> findPropositionParameterTypesForPropositionType(String propositionTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(propositionTypeId, Arrays.asList(PROPOSITION_SERVICE_NAMES), Arrays.asList(PROPOSITION_PARAMETER_SERVICE_NAMES));
    }

    public List<KrmsTypeDefinition> findTermParameterTypesForTermPropositionParameterType(String termPropositionParameterTypeId) throws RiceIllegalArgumentException {
        return this._findTypesForType(termPropositionParameterTypeId, Arrays.asList("termPropositionParameterTypeService"), Arrays.asList("termParameterTypeService"));
    }
}

