/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.type;

import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.type.ActionTypeService;

/**
 * Base class for {@link org.kuali.rice.krms.framework.type.ActionTypeService} implementations, providing
 * boilerplate for attribute building and merging from various sources.
 */
public class ActionTypeServiceBase extends KrmsTypeServiceBase implements ActionTypeService {

    public static final ActionTypeService defaultActionTypeService = new ActionTypeServiceBase();

    @Override
    public Action loadAction(ActionDefinition actionDefinition) {
        throw new UnsupportedOperationException("ActionTypeServiceBase.defaultActionTypeService");
    }
}
