/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.peopleflow;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableAttributeLookupSettings;
import org.kuali.rice.core.api.uif.RemotableQuickFinder;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowService;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.type.ActionTypeService;
import org.kuali.rice.krms.impl.type.KrmsTypeServiceBase;
import org.springframework.orm.ObjectRetrievalFailureException;

public class PeopleFlowActionTypeService
extends KrmsTypeServiceBase
implements ActionTypeService {
    static final String PEOPLE_FLOW_BO_CLASS_NAME = "org.kuali.rice.kew.impl.peopleflow.PeopleFlowBo";
    static final String PEOPLE_FLOWS_SELECTED_ATTRIBUTE = "peopleFlowsSelected";
    public static final String ATTRIBUTE_FIELD_NAME = "peopleFlowId";
    public static final String NAME_ATTRIBUTE_FIELD = "peopleFlowName";
    private final Type type;
    private PeopleFlowService peopleFlowService;
    private ConfigurationService configurationService;

    public static PeopleFlowActionTypeService getInstance(Type type) {
        return new PeopleFlowActionTypeService(type);
    }

    public PeopleFlowActionTypeService(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.type = type;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public Action loadAction(ActionDefinition actionDefinition) {
        if (actionDefinition == null) {
            throw new RiceIllegalArgumentException("actionDefinition must not be null");
        }
        if (actionDefinition.getAttributes() == null || !actionDefinition.getAttributes().containsKey(ATTRIBUTE_FIELD_NAME)) {
            throw new RiceIllegalArgumentException("actionDefinition does not contain an peopleFlowId attribute");
        }
        String peopleFlowId = (String)actionDefinition.getAttributes().get(ATTRIBUTE_FIELD_NAME);
        if (StringUtils.isBlank((String)peopleFlowId)) {
            throw new RiceIllegalArgumentException("peopleFlowId attribute must not be null or blank");
        }
        return new PeopleFlowAction(this.type, peopleFlowId);
    }

    @Override
    public RemotableAttributeField translateTypeAttribute(KrmsTypeAttribute inputAttribute, KrmsAttributeDefinition attributeDefinition) {
        if (ATTRIBUTE_FIELD_NAME.equals(attributeDefinition.getName())) {
            return this.createPeopleFlowIdField();
        }
        if (NAME_ATTRIBUTE_FIELD.equals(attributeDefinition.getName())) {
            return this.createPeopleFlowNameField();
        }
        return super.translateTypeAttribute(inputAttribute, attributeDefinition);
    }

    private RemotableAttributeField createPeopleFlowIdField() {
        String baseLookupUrl = LookupUtils.getBaseLookupUrl();
        RemotableQuickFinder.Builder quickFinderBuilder = RemotableQuickFinder.Builder.create((String)baseLookupUrl, (String)PEOPLE_FLOW_BO_CLASS_NAME);
        HashMap<String, String> lookup = new HashMap<String, String>();
        lookup.put(ATTRIBUTE_FIELD_NAME, "id");
        quickFinderBuilder.setLookupParameters(lookup);
        HashMap<String, String> fieldConversions = new HashMap<String, String>();
        fieldConversions.put("id", ATTRIBUTE_FIELD_NAME);
        fieldConversions.put("name", NAME_ATTRIBUTE_FIELD);
        quickFinderBuilder.setFieldConversions(fieldConversions);
        RemotableTextInput.Builder controlBuilder = RemotableTextInput.Builder.create();
        controlBuilder.setSize(Integer.valueOf(40));
        controlBuilder.setWatermark("PeopleFlow ID");
        RemotableAttributeLookupSettings.Builder lookupSettingsBuilder = RemotableAttributeLookupSettings.Builder.create();
        lookupSettingsBuilder.setCaseSensitive(Boolean.TRUE);
        lookupSettingsBuilder.setInCriteria(true);
        lookupSettingsBuilder.setInResults(true);
        lookupSettingsBuilder.setRanged(false);
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)ATTRIBUTE_FIELD_NAME);
        builder.setAttributeLookupSettings(lookupSettingsBuilder);
        builder.setRequired(true);
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel("PeopleFlow ID");
        builder.setShortLabel("PeopleFlow ID");
        builder.setMinLength(Integer.valueOf(1));
        builder.setMaxLength(Integer.valueOf(40));
        builder.setConstraintText("size 40");
        builder.setWidgets(Collections.singletonList(quickFinderBuilder));
        return builder.build();
    }

    private RemotableAttributeField createPeopleFlowNameField() {
        String baseLookupUrl = LookupUtils.getBaseLookupUrl();
        RemotableTextInput.Builder controlBuilder = RemotableTextInput.Builder.create();
        controlBuilder.setSize(Integer.valueOf(40));
        controlBuilder.setWatermark("PeopleFlow Name");
        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)NAME_ATTRIBUTE_FIELD);
        builder.setRequired(true);
        builder.setDataType(DataType.STRING);
        builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
        builder.setLongLabel("PeopleFlow Name");
        builder.setShortLabel("PeopleFlow Name");
        builder.setMinLength(Integer.valueOf(1));
        builder.setMaxLength(Integer.valueOf(40));
        builder.setConstraintText("size 40");
        return builder.build();
    }

    private void validateNonBlankKrmsTypeId(String krmsTypeId) {
        if (StringUtils.isEmpty((String)krmsTypeId)) {
            throw new RiceIllegalArgumentException("krmsTypeId may not be null or blank");
        }
    }

    @Override
    public List<RemotableAttributeError> validateAttributes(@WebParam(name="krmsTypeId") String krmsTypeId, @WebParam(name="attributes") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> attributes) throws RiceIllegalArgumentException {
        List<RemotableAttributeError> results = null;
        this.validateNonBlankKrmsTypeId(krmsTypeId);
        if (attributes == null) {
            throw new RiceIllegalArgumentException("attributes must not be null");
        }
        RemotableAttributeError.Builder errorBuilder = RemotableAttributeError.Builder.create((String)ATTRIBUTE_FIELD_NAME);
        if (attributes != null && attributes.containsKey(ATTRIBUTE_FIELD_NAME) && StringUtils.isNotBlank((String)attributes.get(ATTRIBUTE_FIELD_NAME))) {
            PeopleFlowDefinition peopleFlowDefinition = null;
            try {
                peopleFlowDefinition = this.getPeopleFlowService().getPeopleFlow(attributes.get(ATTRIBUTE_FIELD_NAME));
            }
            catch (ObjectRetrievalFailureException objectRetrievalFailureException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (peopleFlowDefinition == null) {
                errorBuilder.addErrors(new String[]{MessageFormat.format(this.configurationService.getPropertyValueAsString("peopleFlow.peopleFlowId.invalid"), ATTRIBUTE_FIELD_NAME)});
            }
        } else {
            errorBuilder.addErrors(new String[]{MessageFormat.format(this.configurationService.getPropertyValueAsString("peopleFlow.peopleFlowId.required"), ATTRIBUTE_FIELD_NAME)});
        }
        results = errorBuilder.getErrors().size() > 0 ? Collections.singletonList(errorBuilder.build()) : Collections.emptyList();
        return results;
    }

    @Override
    public List<RemotableAttributeError> validateAttributesAgainstExisting(@WebParam(name="krmsTypeId") String krmsTypeId, @WebParam(name="newAttributes") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> newAttributes, @WebParam(name="oldAttributes") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> oldAttributes) throws RiceIllegalArgumentException {
        if (oldAttributes == null) {
            throw new RiceIllegalArgumentException("oldAttributes must not be null");
        }
        return this.validateAttributes(krmsTypeId, newAttributes);
    }

    public PeopleFlowService getPeopleFlowService() {
        if (this.peopleFlowService == null) {
            this.peopleFlowService = KewApiServiceLocator.getPeopleFlowService();
        }
        return this.peopleFlowService;
    }

    public void setPeopleFlowService(PeopleFlowService peopleFlowService) {
        this.peopleFlowService = peopleFlowService;
    }

    public static enum Type {
        NOTIFICATION(ActionRequestType.FYI),
        APPROVAL(ActionRequestType.APPROVE);

        private final ActionRequestType actionRequestType;

        private Type(ActionRequestType actionRequestType) {
            this.actionRequestType = actionRequestType;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public ActionRequestType getActionRequestType() {
            return this.actionRequestType;
        }

        public static Type fromString(String s) {
            for (Type type : Type.values()) {
                if (!type.toString().equals(s.toLowerCase())) continue;
                return type;
            }
            return null;
        }
    }

    private static class PeopleFlowAction
    implements Action {
        private final Type type;
        private final String peopleFlowId;

        private PeopleFlowAction(Type type, String peopleFlowId) {
            if (type == null) {
                throw new IllegalArgumentException("type must not be null");
            }
            if (StringUtils.isBlank((String)peopleFlowId)) {
                throw new IllegalArgumentException("peopleFlowId must not be null or blank");
            }
            this.type = type;
            this.peopleFlowId = peopleFlowId;
        }

        public void execute(ExecutionEnvironment environment) {
            Object value = environment.getEngineResults().getAttribute(PeopleFlowActionTypeService.PEOPLE_FLOWS_SELECTED_ATTRIBUTE);
            StringBuilder selectedAttributesStringBuilder = new StringBuilder();
            if (value != null) {
                selectedAttributesStringBuilder.append(value.toString());
                selectedAttributesStringBuilder.append(",");
            }
            selectedAttributesStringBuilder.append(this.type.getActionRequestType().getCode());
            selectedAttributesStringBuilder.append(":");
            selectedAttributesStringBuilder.append(this.peopleFlowId);
            environment.getEngineResults().setAttribute(PeopleFlowActionTypeService.PEOPLE_FLOWS_SELECTED_ATTRIBUTE, (Object)selectedAttributesStringBuilder.toString());
        }

        public void executeSimulation(ExecutionEnvironment environment) {
            this.execute(environment);
        }
    }
}

