/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.provider.repository;

import java.util.Collections;
import java.util.List;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.PropositionResult;
import org.kuali.rice.krms.framework.type.PropositionTypeService;
import org.kuali.rice.krms.impl.type.KrmsTypeResolver;

final class LazyProposition
implements Proposition {
    private final PropositionDefinition propositionDefinition;
    private final KrmsTypeResolver resolver;
    private final Object mutex = new Object();
    private volatile Proposition proposition;

    LazyProposition(PropositionDefinition propositionDefinition, KrmsTypeResolver resolver) {
        this.propositionDefinition = propositionDefinition;
        this.resolver = resolver;
        this.proposition = null;
    }

    public PropositionResult evaluate(ExecutionEnvironment environment) {
        return this.getProposition().evaluate(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Proposition getProposition() {
        Proposition localProposition = this.proposition;
        if (localProposition == null) {
            Object object = this.mutex;
            synchronized (object) {
                localProposition = this.proposition;
                if (localProposition == null) {
                    this.proposition = localProposition = this.constructProposition();
                }
            }
        }
        return localProposition;
    }

    private Proposition constructProposition() {
        Proposition proposition = null;
        if (this.propositionDefinition != null) {
            PropositionTypeService propositionTypeService = this.resolver.getPropositionTypeService(this.propositionDefinition);
            proposition = propositionTypeService.loadProposition(this.propositionDefinition);
        }
        if (proposition == null) {
            proposition = new Proposition(this){

                public PropositionResult evaluate(ExecutionEnvironment environment) {
                    return new PropositionResult(true);
                }

                public List<Proposition> getChildren() {
                    return Collections.emptyList();
                }

                public boolean isCompound() {
                    return false;
                }
            };
        }
        return proposition;
    }

    public List<Proposition> getChildren() {
        return this.getProposition().getChildren();
    }

    public boolean isCompound() {
        return this.getProposition().isCompound();
    }
}

