/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.RuleAttributeBo;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoService;

public class RuleBoServiceImpl
implements RuleBoService {
    private DataObjectService dataObjectService;
    private KrmsAttributeDefinitionService attributeDefinitionService;

    @Override
    public RuleDefinition createRule(RuleDefinition rule) {
        String namespaceKey;
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        String nameKey = rule.getName();
        RuleDefinition existing = this.getRuleByNameAndNamespace(nameKey, namespaceKey = rule.getNamespace());
        if (existing != null) {
            throw new IllegalStateException("the rule to create already exists: " + String.valueOf(rule));
        }
        RuleBo ruleBo = RuleBo.from(rule);
        ruleBo = (RuleBo)this.dataObjectService.save((Object)ruleBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        return RuleBo.to(ruleBo);
    }

    @Override
    public RuleDefinition updateRule(RuleDefinition rule) {
        RuleDefinition toUpdate;
        if (rule == null) {
            throw new IllegalArgumentException("rule is null");
        }
        String ruleIdKey = rule.getId();
        RuleBo existing = (RuleBo)this.dataObjectService.find(RuleBo.class, (Object)ruleIdKey);
        if (existing == null) {
            throw new IllegalStateException("the rule does not exist: " + String.valueOf(rule));
        }
        String existingPropositionId = null;
        if (existing.getProposition() != null) {
            existingPropositionId = existing.getProposition().getId();
        }
        if (!existing.getId().equals(rule.getId())) {
            RuleDefinition.Builder builder = RuleDefinition.Builder.create((RuleDefinitionContract)rule);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = rule;
        }
        RuleBo boToUpdate = RuleBo.from(toUpdate);
        this.reconcileActionAttributes(boToUpdate.getActions(), existing.getActions());
        RuleBo updatedData = (RuleBo)this.dataObjectService.save((Object)boToUpdate, new PersistenceOption[]{PersistenceOption.FLUSH});
        if (updatedData.getProposition() != null && StringUtils.isNotBlank((String)existingPropositionId) && !updatedData.getProposition().getId().equals(existingPropositionId)) {
            this.dataObjectService.delete((Object)existing.getProposition());
        }
        return RuleBo.to(updatedData);
    }

    private void reconcileActionAttributes(List<ActionBo> toUpdateActionBos, List<ActionBo> existingActionBos) {
        for (ActionBo toUpdateAction : toUpdateActionBos) {
            ActionBo matchingExistingAction = this.findMatchingExistingAction(toUpdateAction, existingActionBos);
            if (matchingExistingAction == null) continue;
            ListIterator<ActionAttributeBo> toUpdateAttributesIter = toUpdateAction.getAttributeBos().listIterator();
            while (toUpdateAttributesIter.hasNext()) {
                ActionAttributeBo toUpdateAttribute = toUpdateAttributesIter.next();
                ActionAttributeBo matchingExistingAttribute = this.findMatchingExistingAttribute(toUpdateAttribute, matchingExistingAction.getAttributeBos());
                if (matchingExistingAttribute == null) continue;
                matchingExistingAttribute.setValue(toUpdateAttribute.getValue());
                toUpdateAttributesIter.set(matchingExistingAttribute);
            }
        }
    }

    private ActionBo findMatchingExistingAction(ActionBo toUpdateAction, List<ActionBo> existingActionBos) {
        for (ActionBo existingAction : existingActionBos) {
            if (!existingAction.getId().equals(toUpdateAction.getId())) continue;
            return existingAction;
        }
        return null;
    }

    private ActionAttributeBo findMatchingExistingAttribute(ActionAttributeBo toUpdateAttribute, List<ActionAttributeBo> existingAttributeBos) {
        for (ActionAttributeBo existingAttribute : existingAttributeBos) {
            if (!existingAttribute.getAttributeDefinitionId().equals(toUpdateAttribute.getAttributeDefinitionId())) continue;
            return existingAttribute;
        }
        return null;
    }

    @Override
    public void deleteRule(String ruleId) {
        if (ruleId == null) {
            throw new IllegalArgumentException("ruleId is null");
        }
        RuleDefinition existing = this.getRuleByRuleId(ruleId);
        if (existing == null) {
            throw new IllegalStateException("the Rule to delete does not exists: " + ruleId);
        }
        this.dataObjectService.delete((Object)this.from(existing));
    }

    @Override
    public RuleDefinition getRuleByRuleId(String ruleId) {
        if (StringUtils.isBlank((String)ruleId)) {
            throw new IllegalArgumentException("rule id is null");
        }
        RuleBo bo = (RuleBo)this.dataObjectService.find(RuleBo.class, (Object)ruleId);
        return RuleBo.to(bo);
    }

    @Override
    public RuleDefinition getRuleByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        RuleBo myRule = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, RuleBo.class, Collections.unmodifiableMap(map));
        return RuleBo.to(myRule);
    }

    public RuleAttributeBo getRuleAttributeById(String attrId) {
        if (StringUtils.isBlank((String)attrId)) {
            return null;
        }
        RuleAttributeBo bo = (RuleAttributeBo)this.dataObjectService.find(RuleAttributeBo.class, (Object)attrId);
        return bo;
    }

    public RuleBo from(RuleDefinition rule) {
        if (rule == null) {
            return null;
        }
        RuleBo ruleBo = new RuleBo();
        ruleBo.setName(rule.getName());
        ruleBo.setDescription(rule.getDescription());
        ruleBo.setNamespace(rule.getNamespace());
        ruleBo.setTypeId(rule.getTypeId());
        ruleBo.setProposition(PropositionBo.from(rule.getProposition()));
        ruleBo.setId(rule.getId());
        ruleBo.setActive(rule.isActive());
        ruleBo.setVersionNumber(rule.getVersionNumber());
        ruleBo.setActions(this.buildActionBoList(rule));
        ruleBo.setAttributeBos(this.buildAttributeBoList(rule));
        return ruleBo;
    }

    private List<RuleAttributeBo> buildAttributeBoList(RuleDefinition im) {
        LinkedList<RuleAttributeBo> attributes = new LinkedList<RuleAttributeBo>();
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = this.getAttributeDefinitionService().findAttributeDefinitionsByType(im.getTypeId());
        for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
        }
        if (im.getAttributes() != null) {
            for (Map.Entry entry : im.getAttributes().entrySet()) {
                KrmsAttributeDefinition attrDef = (KrmsAttributeDefinition)attributeDefinitionMap.get(entry.getKey());
                if (attrDef != null) {
                    RuleAttributeBo attributeBo = new RuleAttributeBo();
                    attributeBo.setRule(RuleBo.from(im));
                    attributeBo.setValue((String)entry.getValue());
                    attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attrDef));
                    attributes.add(attributeBo);
                    continue;
                }
                throw new RiceIllegalStateException("there is no attribute definition with the name '" + (String)entry.getKey() + "' that is valid for the rule type with id = '" + im.getTypeId() + "'");
            }
        }
        return attributes;
    }

    private List<ActionBo> buildActionBoList(RuleDefinition im) {
        LinkedList<ActionBo> actions = new LinkedList<ActionBo>();
        for (ActionDefinition actionDefinition : im.getActions()) {
            actions.add(ActionBo.from(actionDefinition));
        }
        return actions;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public List<RuleDefinition> convertListOfBosToImmutables(Collection<RuleBo> ruleBos) {
        ArrayList<RuleDefinition> rules = new ArrayList<RuleDefinition>();
        for (RuleBo bo : ruleBos) {
            RuleDefinition rule = RuleBo.to(bo);
            rules.add(rule);
        }
        return Collections.unmodifiableList(rules);
    }

    protected KrmsAttributeDefinitionService getAttributeDefinitionService() {
        if (this.attributeDefinitionService == null) {
            this.attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        }
        return this.attributeDefinitionService;
    }
}

