/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.authorization;

import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADConstants;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;

import java.util.HashMap;
import java.util.Map;

public class AgendaAuthorizationServiceImpl implements AgendaAuthorizationService {

    static final String NAMESPACE_CODE = "namespaceCode";

    @Override
    public boolean isAuthorized(String permissionName, String contextId) {
        String namespace = "";
        if (contextId != null) {
            ContextDefinition context = getContextBoService().getContextByContextId(contextId);
            if (context != null) { // business rules should have already reported this as an error.
                namespace = context.getNamespace();
            }
        }

        Map<String, String> qualification = new HashMap<String, String>();
        boolean isAuthorized = getPermissionService().isAuthorized(
                GlobalVariables.getUserSession().getPrincipalId(),
                namespace,
                permissionName,
                qualification);
        return isAuthorized;
    }

    /**
     * return the contextBoService
     */
    private ContextBoService getContextBoService() {
        return KrmsRepositoryServiceLocator.getContextBoService();
    }

    /**
     * returns the permissionService
     */
    private PermissionService getPermissionService() {
        return KimApiServiceLocator.getPermissionService();
    }
}
