/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.kuali.rice.core.api.criteria.CriteriaLookupService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.authorization.AgendaAuthorizationService;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;

import javax.xml.namespace.QName;

/**
 * This class keeps track of the KRMS Repository Services
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class KrmsRepositoryServiceLocator {

    private KrmsRepositoryServiceLocator() {
        // private constructor since this is class is all static utility methods
    }

	private static final Logger LOG = LogManager.getLogger(KrmsRepositoryServiceLocator.class);

    public static final String KRMS_ATTRIBUTE_DEFINITION_SERVICE = "krmsAttributeDefinitionService";
    public static final String KRMS_TYPE_REPOSITORY_SERVICE = "krmsTypeRepositoryService";
    public static final String CRITERIA_LOOKUP_SERVICE = "criteriaLookupService";
    public static final String KRMS_CONTEXT_BO_SERVICE = "contextBoService";
    public static final String KRMS_AGENDA_BO_SERVICE = "agendaBoService";
    public static final String KRMS_FUNCTION_BO_SERVICE = "functionBoService";
    public static final String KRMS_TERM_BO_SERVICE = "termBoService";
    public static final String KRMS_RULE_BO_SERVICE = "ruleBoService";
    public static final String KRMS_AGENDA_AUTHORIZATION_SERVICE = "agendaAuthorizationService";
    public static final String KRMS_REPOSITORY_TO_ENGINE_TRANSLATOR = "repositoryToEngineTranslator";
    public static final String TYPE_TYPE_RELATION_BO_SERVICE = "typeTypeRelationBoService";
    public static final String KRMS_PROPOSITION_BO_SERVICE = "propositionBoService";

	private static KrmsAttributeDefinitionService krmsAttributeDefinitionService;
    private static ContextBoService contextBoService;
    private static TermBoService termBoService;
    private static AgendaBoService agendaBoService;
    private static FunctionBoService functionBoService;
    private static RuleBoService ruleBoService;
    private static AgendaAuthorizationService agendaAuthorizationService;
    private static KrmsTypeRepositoryService krmsTypeRepositoryService;
    private static RepositoryToEngineTranslator krmsRepositoryToEngineTranslator;
    private static TypeTypeRelationBoService typeTypeRelationBoService;
    private static PropositionBoService propositionBoService;

    public static <T extends Object> T getService(String serviceName) {
		return KrmsRepositoryServiceLocator.<T>getBean(serviceName);
	}

	public static <T extends Object> T getBean(String serviceName) {
		if ( LOG.isDebugEnabled() ) {
			LOG.debug("Fetching service " + serviceName);
		}
		return GlobalResourceLoader.<T>getService(QName.valueOf(serviceName));
	}

    public static KrmsAttributeDefinitionService getKrmsAttributeDefinitionService() {
		if ( krmsAttributeDefinitionService == null ) {
			krmsAttributeDefinitionService = getService(KRMS_ATTRIBUTE_DEFINITION_SERVICE);
		}
		return krmsAttributeDefinitionService;
    }

    public static CriteriaLookupService getCriteriaLookupService() {
        return getService(CRITERIA_LOOKUP_SERVICE);
    }

	public static void setKrmsAttributeDefinitionService(final KrmsAttributeDefinitionService service) {
		krmsAttributeDefinitionService = service;
	}

    public static ContextBoService getContextBoService() {
        if (contextBoService == null) {
            contextBoService = getService(KRMS_CONTEXT_BO_SERVICE);
        }
        return contextBoService;
    }

    public static TermBoService getTermBoService() {
        if (termBoService == null) {
            termBoService = getService(KRMS_TERM_BO_SERVICE);
        }
        return termBoService;
    }

    public static AgendaBoService getAgendaBoService() {
        if (agendaBoService == null) {
            agendaBoService = getService(KRMS_AGENDA_BO_SERVICE);
        }
        return agendaBoService;
    }

    public static FunctionBoService getFunctionBoService() {
        if (functionBoService == null) {
            functionBoService = getService(KRMS_FUNCTION_BO_SERVICE);
        }
        return functionBoService;
    }

    public static RuleBoService getRuleBoService() {
        if (ruleBoService == null) {
            ruleBoService = getService(KRMS_RULE_BO_SERVICE);
        }
        return ruleBoService;
    }

    public static AgendaAuthorizationService getAgendaAuthorizationService() {
        if (agendaAuthorizationService == null) {
            agendaAuthorizationService = getService(KRMS_AGENDA_AUTHORIZATION_SERVICE);
        }
        return agendaAuthorizationService;
    }

    public static KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        if (krmsTypeRepositoryService == null) {
            krmsTypeRepositoryService = getService(KRMS_TYPE_REPOSITORY_SERVICE);
        }
        return krmsTypeRepositoryService;
    }

    public static RepositoryToEngineTranslator getKrmsRepositoryToEngineTranslator() {
        if (krmsRepositoryToEngineTranslator == null) {
            krmsRepositoryToEngineTranslator = getService(KRMS_REPOSITORY_TO_ENGINE_TRANSLATOR);
        }
        return krmsRepositoryToEngineTranslator;
    }

    public static TypeTypeRelationBoService getTypeTypeRelationBoService() {
        if (typeTypeRelationBoService == null) {
            typeTypeRelationBoService = getService(TYPE_TYPE_RELATION_BO_SERVICE);
        }
        return typeTypeRelationBoService;
    }

    public static PropositionBoService getPropositionBoService() {
        if (propositionBoService == null) {
            propositionBoService = getService(KRMS_PROPOSITION_BO_SERVICE);
        }
        return propositionBoService;
    }
}
