/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.CoreConfigHelper;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.security.credentials.CredentialsType;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.BasicEndpoint;

public abstract class AbstractServiceDefinition
implements ServiceDefinition {
    private static final Logger LOG = Logger.getLogger(AbstractServiceDefinition.class);
    private String localServiceName;
    private String serviceNameSpaceURI;
    private Object service;
    private QName serviceName;
    private boolean queue = true;
    private Integer priority;
    private Integer retryAttempts;
    private Long millisToLive;
    private String messageExceptionHandler;
    private String servicePath;
    private URL endpointUrl;
    private Boolean busSecurity = Boolean.TRUE;
    private CredentialsType credentialsType;
    private String serviceVersion;
    private String applicationId;
    private String instanceId;
    private ClassLoader serviceClassLoader = ClassLoaderUtils.getDefaultClassLoader();
    private boolean basicAuthentication = false;

    protected AbstractServiceDefinition() {
    }

    @Override
    public boolean isBasicAuthentication() {
        return this.basicAuthentication;
    }

    public void setBasicAuthentication(boolean basicAuthentication) {
        this.basicAuthentication = basicAuthentication;
    }

    @Override
    public Object getService() {
        return this.service;
    }

    public void setService(Object service) {
        this.service = service;
    }

    public String getLocalServiceName() {
        return this.localServiceName;
    }

    public void setLocalServiceName(String serviceName) {
        this.localServiceName = serviceName;
    }

    @Override
    public String getMessageExceptionHandler() {
        return this.messageExceptionHandler;
    }

    public void setMessageExceptionHandler(String messageExceptionHandler) {
        this.messageExceptionHandler = messageExceptionHandler;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Override
    public boolean isQueue() {
        return this.queue;
    }

    public void setQueue(boolean queue) {
        this.queue = queue;
    }

    @Override
    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    @Override
    public QName getServiceName() {
        if (this.serviceName == null) {
            if (this.serviceNameSpaceURI == null) {
                return new QName(this.applicationId, this.localServiceName);
            }
            return new QName(this.serviceNameSpaceURI, this.localServiceName);
        }
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public URL getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(URL endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public void setCredentialsType(CredentialsType credentialsType) {
        this.credentialsType = credentialsType;
    }

    @Override
    public CredentialsType getCredentialsType() {
        return this.credentialsType;
    }

    @Override
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public void setServiceClassLoader(ClassLoader serviceClassLoader) {
        this.serviceClassLoader = serviceClassLoader;
    }

    @Override
    public void validate() {
        if (this.serviceName == null && this.localServiceName == null) {
            throw new ConfigurationException("Must give a serviceName or localServiceName");
        }
        if (this.applicationId == null) {
            String applicationId = CoreConfigHelper.getApplicationId();
            if (applicationId == null) {
                throw new ConfigurationException("Must have an applicationId");
            }
            this.applicationId = applicationId;
        }
        if (this.instanceId == null) {
            String instanceId = CoreConfigHelper.getInstanceId();
            if (instanceId == null) {
                throw new ConfigurationException("Must have an instanceId");
            }
            this.instanceId = instanceId;
        }
        if (this.serviceName != null && this.localServiceName == null) {
            this.localServiceName = this.getServiceName().getLocalPart();
        }
        if (this.servicePath != null) {
            if (this.servicePath.endsWith("/")) {
                this.servicePath = StringUtils.chop((String)this.servicePath);
            }
            if (!this.servicePath.startsWith("/")) {
                this.servicePath = "/" + this.servicePath;
            }
        } else {
            this.servicePath = "/";
        }
        if (StringUtils.isBlank((String)this.serviceVersion)) {
            this.setServiceVersion("unspecifiedVersion");
        }
        LOG.debug((Object)("Validating service " + this.serviceName));
        if (this.endpointUrl == null) {
            String endPointURL = ConfigContext.getCurrentContextConfig().getEndPointUrl();
            if (endPointURL == null) {
                throw new ConfigurationException("Must provide a serviceEndPoint or serviceServletURL");
            }
            endPointURL = !endPointURL.endsWith("/") ? endPointURL + this.servicePath : StringUtils.chop((String)endPointURL) + this.servicePath;
            try {
                this.endpointUrl = this.servicePath.equals("/") ? new URL(endPointURL + this.getServiceName().getLocalPart()) : new URL(endPointURL + "/" + this.getServiceName().getLocalPart());
            }
            catch (Exception e) {
                throw new ConfigurationException("Service Endpoint URL creation failed.", (Throwable)e);
            }
        }
        if (this.priority == null) {
            this.setPriority(5);
        }
        if (this.retryAttempts == null) {
            this.setRetryAttempts(0);
        }
        if (this.millisToLive == null) {
            this.setMillisToLive(new Long(-1L));
        }
    }

    @Override
    public Endpoint establishEndpoint() {
        return BasicEndpoint.newEndpoint(this.configure(), this.getService());
    }

    protected abstract ServiceConfiguration configure();

    public String getServiceNameSpaceURI() {
        return this.serviceNameSpaceURI;
    }

    public void setServiceNameSpaceURI(String serviceNameSpaceURI) {
        this.serviceNameSpaceURI = serviceNameSpaceURI;
    }

    @Override
    public Long getMillisToLive() {
        return this.millisToLive;
    }

    public void setMillisToLive(Long millisToLive) {
        this.millisToLive = millisToLive;
    }

    @Override
    public Boolean getBusSecurity() {
        return this.busSecurity;
    }

    public void setBusSecurity(Boolean busSecurity) {
        this.busSecurity = busSecurity;
    }

    @Override
    public String getServicePath() {
        return this.servicePath;
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public boolean equals(Object object) {
        return EqualsBuilder.reflectionEquals((Object)object, (Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

