/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.api.bus.support;

import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.api.KsbApiConstants;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class JavaServiceDefinition extends AbstractServiceDefinition {
	
	private List<String> serviceInterfaces = new ArrayList<String>();

	@Override
	public String getType() {
		return KsbApiConstants.ServiceTypes.HTTP_INVOKER;
	}
	
	public List<String> getServiceInterfaces() {
		return this.serviceInterfaces;
	}
	public void setServiceInterfaces(List<String> serviceInterfaces) {
		this.serviceInterfaces = serviceInterfaces;
	}
	public void setServiceInterface(String serviceName) {
	    this.serviceInterfaces.add(serviceName);
	}
	public String getServiceInterface() {
		return this.serviceInterfaces.get(0);
	}
	
	@Override
	public void validate() {
		super.validate();
		if (this.serviceInterfaces == null || this.serviceInterfaces.isEmpty()) {
			Class<?>[] interfaces = ClassLoaderUtils.getInterfacesToProxy(getService(), null, null);
			for (Class<?> serviceInterfaceClass : interfaces) {
			    this.serviceInterfaces.add(serviceInterfaceClass.getName());
			}
		}
	}
	
	@Override
    protected ServiceConfiguration configure() {
		return JavaServiceConfiguration.fromServiceDefinition(this);
	}
	
	/**
     * Defines some internal constants used on this class.
     */
    static class Constants {
    	final static String ROOT_ELEMENT_NAME = "javaServiceDefinition";
        final static String TYPE_NAME = "JavaServiceDefinitionType";
    }

    /**
     * A private class which exposes constants which define the XML element names to use
     * when this object is marshalled to XML.
     */
    protected static class Elements {
    	protected final static String SERVICE_INTERFACES = "serviceInterfaces";
    	protected final static String SERVICE_INTERFACE = "serviceInterface";
    }
	
}
