/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.api.bus.support;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.property.ConfigContext;

/**
 * A ServiceBusExporter which only exports the service if the specified property is set
 * to true.
 * 
 * @author Kuali Rice Team (kuali-rice@googlegroups.com)
 */
public class PropertyConditionalServiceBusExporter extends ServiceBusExporter {

	private List<String> exportIf = new ArrayList<String>();
	private List<String> exportUnless = new ArrayList<String>();
	private boolean exportIfPropertyNotSet = true;

	@Override
    public void afterPropertiesSet() {
		if (shouldRemoteThisService()) {
			super.afterPropertiesSet();
		}
	}
	
	protected boolean shouldRemoteThisService() {
		if (exportIf.isEmpty() && exportUnless.isEmpty()) {
			return true;
		}
		boolean remoteThisService = false;
		String serviceValue = null;
		// Check the value in the clients config file for services in the list
		// of property named 'exportIf' loaded by Spring.
		// if any are ="true" then set boolean to true and exit loop, so far the
		// service will be published.
		for (String expIf : exportIf) {
			serviceValue = ConfigContext.getCurrentContextConfig().getProperty(expIf);
			// if any are true, set boolean and exit loop.
			if (!StringUtils.isBlank(serviceValue)) {
				remoteThisService = Boolean.parseBoolean(serviceValue);
				if (remoteThisService) {
					break;
				}
			} else if (exportIfPropertyNotSet) {
				remoteThisService = true;
				break;
			}
		}
		// Check a second list, if any are ="true" DON"T publish the service.
		for (String expUnless : exportUnless) {
			serviceValue = ConfigContext.getCurrentContextConfig()
					.getProperty(expUnless);
			// if any are true, set boolean and exit loop.
			if (!StringUtils.isBlank(serviceValue)) {
				remoteThisService = Boolean.parseBoolean(serviceValue);
				if (remoteThisService) {
					remoteThisService = false;
					break;
				}
			}
		}
		return remoteThisService;
	}

	public List<String> getExportIf() {
		return this.exportIf;
	}

	public void setExportIf(List<String> exportIf) {
		this.exportIf = exportIf;
	}

	public List<String> getExportUnless() {
		return this.exportUnless;
	}

	public void setExportUnless(List<String> exportUnless) {
		this.exportUnless = exportUnless;
	}

	public boolean isExportIfPropertyNotSet() {
		return this.exportIfPropertyNotSet;
	}

	public void setExportIfPropertyNotSet(boolean exportIfPropertyNotSet) {
		this.exportIfPropertyNotSet = exportIfPropertyNotSet;
	}

}
