/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.api.registry;

import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;

/**
 * A service descriptor includes a serialized XML representation of the
 * {@link ServiceConfiguration} for the service.
 * 
 * <p>It's expected that a client of this service which needs this information
 * will materialize this value when it's needed to obtain additional
 * information about the configuration information for the service.  The
 * process for materializing the information can be dependent upon the
 * type of the {@link ServiceInfo} which contains this descriptor. 
 * 
 * <p>The separation of this descriptor information from the main
 * {@link ServiceInfo} allows for clients of the registry to only load the
 * basic information about the services in the registry, and then pull in the
 * full descriptor for the services they actually need to invoke and work with. 
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface ServiceDescriptorContract extends Versioned {

	/**
	 * Returns the id of this service descriptor.  This value should be unique
	 * across service descriptors.  This value is generated when the service
	 * is published to the registry, so this value can be null if the service
	 * has not yet been published to the registry.
	 * 
	 * @return the id of this service descriptor, or null if the service and
	 * it's descriptor has not yet been published to the registry
	 */
	String getId();
	
	/**
	 * Returns an XML value which can be used to materialize the {@link ServiceConfiguration}
	 * for the service.
	 * 
	 * @return the XML representation of the {@link ServiceConfiguration} for the service,
	 * should never return a null or blank value
	 */
	String getDescriptor();

    /**
     * Deprecated: Will always return null as service descriptors have no version number column. This was included on
     * the contract interface by mistake during the original implementation.
     *
     * @return always returns null
     * @deprecated always returns null
     */
    @Deprecated
    @Override
    Long getVersionNumber();



}
