/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.api.bus.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.ServiceBus;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.springframework.beans.factory.InitializingBean;

public class ServiceBusExporter
implements InitializingBean {
    private static Logger LOG = LogManager.getLogger(ServiceBusExporter.class);
    private ServiceDefinition serviceDefinition;
    private boolean forceSync = false;
    private ServiceBus serviceBus;

    public void afterPropertiesSet() {
        if (this.getServiceDefinition() == null) {
            throw new IllegalStateException("serviceDefinition must be set");
        }
        this.getServiceDefinition().validate();
        if (LOG.isInfoEnabled()) {
            LOG.info("Attempting to export service with service name '" + String.valueOf(this.getServiceDefinition().getServiceName()));
        }
        if (this.getServiceBus() == null) {
            this.setServiceBus(this.autoLocateServiceBus());
        }
        if (this.getServiceBus() == null) {
            throw new IllegalStateException("serviceBus could not be located and was not set, must not be null");
        }
        this.getServiceBus().publishService(this.getServiceDefinition(), this.forceSync);
    }

    protected ServiceBus autoLocateServiceBus() {
        return KsbApiServiceLocator.getServiceBus();
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void setServiceDefinition(ServiceDefinition serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    public void setForceRefresh(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public ServiceBus getServiceBus() {
        return this.serviceBus;
    }

    public void setServiceBus(ServiceBus serviceBus) {
        this.serviceBus = serviceBus;
    }
}

