/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.InterruptedIOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.ConnectionPoolTimeoutException;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.api.util.ContextClassLoaderProxy;
import org.kuali.rice.core.api.util.reflect.BaseTargetedInvocationHandler;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.api.bus.Endpoint;
import org.kuali.rice.ksb.api.bus.ServiceConfiguration;
import org.kuali.rice.ksb.messaging.HttpException;

public class BusClientFailureProxy
extends BaseTargetedInvocationHandler {
    private static final Logger LOG = Logger.getLogger(BusClientFailureProxy.class);
    private final Object failoverLock = new Object();
    private ServiceConfiguration serviceConfiguration;
    private static List<Class<?>> serviceRemovalExceptions = new ArrayList();
    private static List<Integer> serviceRemovalResponseCodes = new ArrayList<Integer>();

    private BusClientFailureProxy(Object target, ServiceConfiguration serviceConfiguration) {
        super(target);
        this.serviceConfiguration = serviceConfiguration;
    }

    public static Object wrap(Object target, ServiceConfiguration serviceConfiguration) {
        return Proxy.newProxyInstance(ClassLoaderUtils.getDefaultClassLoader(), ContextClassLoaderProxy.getInterfacesToProxy((Object)target), (InvocationHandler)((Object)new BusClientFailureProxy(target, serviceConfiguration)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invokeInternal(Object proxyObject, Method method, Object[] params) throws Throwable {
        HashSet<ServiceConfiguration> servicesTried = null;
        while (true) {
            try {
                return method.invoke(this.getTarget(), params);
            }
            catch (Throwable throwable) {
                if (BusClientFailureProxy.isServiceRemovalException(throwable)) {
                    Object object = this.failoverLock;
                    synchronized (object) {
                        LOG.error((Object)("Exception caught accessing remote service " + this.serviceConfiguration.getServiceName() + " at " + this.serviceConfiguration.getEndpointUrl()), throwable);
                        if (servicesTried == null) {
                            servicesTried = new HashSet<ServiceConfiguration>();
                            servicesTried.add(this.serviceConfiguration);
                        }
                        Object failoverService = null;
                        List endpoints = KsbApiServiceLocator.getServiceBus().getEndpoints(this.serviceConfiguration.getServiceName(), this.serviceConfiguration.getApplicationId());
                        for (Endpoint endpoint : endpoints) {
                            if (servicesTried.contains(endpoint.getServiceConfiguration())) continue;
                            failoverService = endpoint.getService();
                            if (Proxy.isProxyClass(failoverService.getClass()) && Proxy.getInvocationHandler(failoverService) instanceof BusClientFailureProxy) {
                                failoverService = ((BusClientFailureProxy)((Object)Proxy.getInvocationHandler(failoverService))).getTarget();
                            }
                            servicesTried.add(endpoint.getServiceConfiguration());
                            break;
                        }
                        if (failoverService == null) {
                            LOG.error((Object)"Didn't find replacement service throwing exception");
                            throw throwable;
                        }
                        LOG.info((Object)("Refetched replacement service for service " + this.serviceConfiguration.getServiceName() + " at " + this.serviceConfiguration.getEndpointUrl()));
                        this.setTarget(failoverService);
                    }
                    continue;
                }
                throw throwable;
            }
            break;
        }
    }

    private static boolean isServiceRemovalException(Throwable throwable) {
        HTTPException httpException;
        LOG.info((Object)("Checking for Service Removal Exception: " + throwable.getClass().getName()));
        if (serviceRemovalExceptions.contains(throwable.getClass())) {
            LOG.info((Object)("Found a Service Removal Exception: " + throwable.getClass().getName()));
            return true;
        }
        if (throwable instanceof HttpException) {
            HttpException httpException2 = (HttpException)((Object)throwable);
            if (serviceRemovalResponseCodes.contains(httpException2.getResponseCode())) {
                LOG.info((Object)("Found a Service Removal Exception because of a " + httpException2.getResponseCode() + " " + throwable.getClass().getName()));
                return true;
            }
        } else if (throwable instanceof HTTPException && serviceRemovalResponseCodes.contains((httpException = (HTTPException)throwable).getResponseCode())) {
            LOG.info((Object)("Found a Service Removal Exception because of a " + httpException.getResponseCode() + " " + throwable.getClass().getName()));
            return true;
        }
        if (throwable.getCause() != null) {
            LOG.info((Object)("Unwrapping Throwable cause to check for service removal exception from: " + throwable.getClass().getName()));
            return BusClientFailureProxy.isServiceRemovalException(throwable.getCause());
        }
        return false;
    }

    static {
        serviceRemovalExceptions.add(NoHttpResponseException.class);
        serviceRemovalExceptions.add(InterruptedIOException.class);
        serviceRemovalExceptions.add(UnknownHostException.class);
        serviceRemovalExceptions.add(NoRouteToHostException.class);
        serviceRemovalExceptions.add(ConnectTimeoutException.class);
        serviceRemovalExceptions.add(ConnectionPoolTimeoutException.class);
        serviceRemovalExceptions.add(ConnectException.class);
        serviceRemovalExceptions.add(SocketTimeoutException.class);
        serviceRemovalResponseCodes.add(new Integer(404));
        serviceRemovalResponseCodes.add(new Integer(503));
    }
}

