/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.util.ArrayList;
import org.aopalliance.aop.Advice;
import org.apache.log4j.Logger;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.ksb.api.bus.support.JavaServiceConfiguration;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

public class KSBHttpInvokerProxyFactoryBean
extends HttpInvokerProxyFactoryBean {
    private static final Logger LOG = Logger.getLogger(KSBHttpInvokerProxyFactoryBean.class);
    private Object serviceProxy;
    private JavaServiceConfiguration serviceConfiguration;

    public JavaServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public void setServiceConfiguration(JavaServiceConfiguration serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    public void afterPropertiesSet() {
        ProxyFactory proxyFactory = new ProxyFactory((Class[])this.getServiceInterfaces());
        proxyFactory.addAdvice((Advice)this);
        LOG.debug((Object)("Http proxying service " + this.getServiceConfiguration()));
        this.serviceProxy = proxyFactory.getProxy();
    }

    public Object getObject() {
        return this.serviceProxy;
    }

    public Class<?> getObjectType() {
        return this.getObject().getClass();
    }

    public boolean isSingleton() {
        return false;
    }

    public Class<?>[] getServiceInterfaces() {
        ArrayList serviceInterfaces = new ArrayList();
        try {
            for (String interfaceName : this.getServiceConfiguration().getServiceInterfaces()) {
                Class<?> clazz = Class.forName(interfaceName, true, ClassLoaderUtils.getDefaultClassLoader());
                LOG.debug((Object)("Adding service interface '" + clazz + "' to proxy object for service " + this.getServiceConfiguration()));
                serviceInterfaces.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return serviceInterfaces.toArray(new Class[0]);
    }
}

