/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.rice.core.api.util.io.SerializationUtils;
import org.kuali.rice.ksb.api.messaging.AsynchronousCall;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;

@Entity
@Table(name="KRSB_MSG_PYLD_T")
public class PersistedMessagePayload
implements Serializable {
    private static final long serialVersionUID = 508778527504899029L;
    @Id
    @Column(name="MSG_QUE_ID")
    private Long routeQueueId;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="MSG_PYLD", length=4000)
    private String payload;
    @Transient
    private AsynchronousCall methodCall;
    @Transient
    private PersistedMessageBO message;

    public PersistedMessagePayload() {
    }

    public PersistedMessagePayload(AsynchronousCall methodCall, PersistedMessageBO message) {
        this.setPayload(SerializationUtils.serializeToBase64((Serializable)methodCall));
        this.methodCall = methodCall;
        this.message = message;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Long getRouteQueueId() {
        return this.routeQueueId;
    }

    public void setRouteQueueId(Long routeQueueId) {
        this.routeQueueId = routeQueueId;
    }

    public AsynchronousCall getMethodCall() {
        if (this.methodCall != null) {
            return this.methodCall;
        }
        this.methodCall = (AsynchronousCall)SerializationUtils.deserializeFromBase64((String)this.getPayload());
        return this.methodCall;
    }

    public PersistedMessageBO getMessage() {
        return this.message;
    }

    public void setMessage(PersistedMessageBO message) {
        this.message = message;
    }

    public void setMethodCall(AsynchronousCall methodCall) {
        this.methodCall = methodCall;
    }
}

