/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.bam.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.ksb.messaging.bam.BAMTargetEntry;
import org.kuali.rice.ksb.messaging.bam.dao.BAMDAO;

public class BAMDaoJpaImpl
implements BAMDAO {
    private EntityManager entityManager;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void clearBAMTables() {
        this.entityManager.createQuery("delete from BAMTargetEntry").executeUpdate();
        this.entityManager.createQuery("delete from BAMParam").executeUpdate();
    }

    @Override
    public List<BAMTargetEntry> getCallsForService(QName serviceName, String methodName) {
        return this.entityManager.createQuery("select bte from BAMTargetEntry bte where bte.serviceName = :serviceName and bte.methodName = :methodName").setParameter("serviceName", (Object)serviceName.toString()).setParameter("methodName", (Object)methodName).getResultList();
    }

    @Override
    public void save(BAMTargetEntry bamEntry) {
        if (bamEntry.getBamId() == null) {
            this.entityManager.persist((Object)bamEntry);
        } else {
            this.entityManager.merge((Object)bamEntry);
        }
    }

    @Override
    public List<BAMTargetEntry> getCallsForService(QName serviceName) {
        return this.entityManager.createQuery("select bte from BAMTargetEntry bte where bte.serviceName = :serviceName").setParameter("serviceName", (Object)serviceName.toString()).getResultList();
    }

    @Override
    public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef) {
        QName qname = new QName(objDef.getApplicationId(), objDef.getClassName());
        return this.entityManager.createQuery("select bte from BAMTargetEntry bte where bte.serviceName like :serviceName%").setParameter("serviceName", (Object)qname.toString()).getResultList();
    }

    @Override
    public List<BAMTargetEntry> getCallsForRemotedClasses(ObjectDefinition objDef, String methodName) {
        QName qname = new QName(objDef.getApplicationId(), objDef.getClassName());
        return this.entityManager.createQuery("select bte from BAMTargetEntry bte where bte.serviceName like :serviceName% and bte.methodName = :methodName").setParameter("serviceName", (Object)qname.toString()).setParameter("methodName", (Object)methodName).getResultList();
    }
}

